﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/g3d/edit/detail/g3d_EditDetailDefs.h>

#if NW_G3D_CONFIG_USE_HOSTIO

#include "ut/g3d_EditWorkBuffer.h"

namespace nw { namespace g3d {

class MaterialObj;

namespace edit {

class IAllocator;

namespace detail {

class EditMaterialObj;

class EditRenderInfoObj
{
    friend class EditMaterialObj;
public:
    void Cleanup();

    void Destroy();

    void UpdateMaterial(nw::g3d::res::ResMaterial* resMaterial);
    void Update(const void* pRenderInfoDic, size_t dataSize);
private:
    EditRenderInfoObj(
        IAllocator* allocator,
        nw::g3d::MaterialObj* ownerMaterialObj);

    IAllocator*                     m_pAllocator;

    nw::g3d::MaterialObj*           m_pOwnerMaterial;
    nw::g3d::res::ResMaterial*      m_pOriginalMaterial;
    void*                           m_pOriginalRenderInfoDic;
    u16                             m_OriginalNumRenderInfo;
    ut::detail::EditWorkBuffer    m_WorkBuffer;

    nw::g3d::res::ResMaterial*      m_pUpdatedMaterial;
    void*                           m_pUpdatedRenderInfoDic;
    u16                             m_UpdateNumRenderInfo;

    NW_G3D_DISALLOW_COPY_AND_ASSIGN(EditRenderInfoObj);
};

}}}} // namespace nw::g3d::edit::detail

#endif // NW_G3D_CONFIG_USE_HOSTIO
