﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/g3d/edit/detail/g3d_EditDetailDefs.h>

#if NW_G3D_CONFIG_USE_HOSTIO

#include "ut/g3d_FixedSizeArray.h"
#include "g3d_EditRenderInfoObj.h"
#include "g3d_EditBlinkingObj.h"

namespace nw { namespace g3d {

class ModelObj;
class MaterialObj;

namespace res {

class ResSampler;

} // namespace nw::g3d::res

namespace edit {

class IAllocator;

namespace detail {

class EditModelObj;
class EditSampler;

class EditMaterialObj : public BlinkingObj
{
public:
    explicit EditMaterialObj(
        IAllocator* allocator,
        int index,
        nw::g3d::ModelObj* ownerModelObj,
        nw::g3d::MaterialObj* materialObj);

    bool Init();
    void Destroy();

    void Setup();
    void Cleanup();
    void UpdateRenderInfo(const void* pRenderInfoDic, size_t dataSize);

    bool GetMaterialVisibilityEnabled() const
    {
        return m_MaterialVisibilityEnable;
    }

    bool ReinitBuffer(nw::g3d::res::ResMaterial* resMaterial);
    void SetupMaterialInstance(nw::g3d::res::ResMaterial* resMaterial);

private:
    virtual void Show() throw();
    virtual void Hide() throw();
    virtual bool IsVisibleByDefault() const throw();

    void DestroySamplers();
    bool ReinitBlockBuffer();
    void CleanupSamplers();

    IAllocator*         m_pAllocator;

    ut::detail::FixedSizeArray<EditSampler> m_SamplerArray;

    int m_Index;
    nw::g3d::ModelObj*          m_pOwnerModel;
    nw::g3d::MaterialObj*       m_pMaterial;
    nw::g3d::res::ResMaterial*  m_pOriginalMaterial;

    void*                       m_pOriginalBuffer;
    u32                         m_OriginalBufferSize;
    int                         m_OriginalBufferingCount;

    void*                       m_pOriginalBlockBuffer;
    u32                         m_OriginalBlockBufferSize;

    ut::detail::EditWorkBuffer    m_WorkBuffer;
    ut::detail::EditWorkBuffer    m_WorkBlockBuffer;

    EditRenderInfoObj               m_RenderInfo;

    bool m_MaterialVisibilityEnable;
    GX2Boolean m_CullFront;
    GX2Boolean m_CullBack;

private:
    NW_G3D_DISALLOW_COPY_AND_ASSIGN(EditMaterialObj);
};

class EditSampler
{
    friend class EditMaterialObj;
public:
    void Setup();
    void Cleanup();
private:
    EditSampler(
        int index,
        nw::g3d::MaterialObj* ownerMaterialObj,
        nw::g3d::res::ResSampler* resSampler)
        : m_Index(index)
        , m_pOwnerMaterial(ownerMaterialObj)
        , m_pSampler(resSampler)
    {}

    int m_Index;
    nw::g3d::MaterialObj* m_pOwnerMaterial;
    nw::g3d::res::ResSampler* m_pSampler;

    GX2TexClamp m_WrapU;
    GX2TexClamp m_WrapV;
    GX2TexClamp m_WrapW;

    GX2TexXYFilterType  m_MagFilter;
    GX2TexXYFilterType  m_MinFilter;
    GX2TexMipFilterType m_MipFilter;
    GX2TexAnisoRatio    m_MaxAniso;
private:
    NW_G3D_DISALLOW_COPY_AND_ASSIGN(EditSampler);
};

}}}} // namespace nw::g3d::edit::detail

#endif // NW_G3D_CONFIG_USE_HOSTIO
