﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "g3d_EditBone.h"

#if NW_G3D_CONFIG_USE_HOSTIO

#include <nw/g3d/res/g3d_ResSkeleton.h>

namespace nw { namespace g3d { namespace edit { namespace detail {

using namespace nw::g3d::res;

static const bit32 VISIBILITY_CLEAR_MASK = static_cast<bit32>(~ResBone::VISIBILITY);
static const bit32 BILLBOARD_CLEAR_MASK = static_cast<bit32>(~ResBone::BILLBOARD_MASK);

void EditBone::Setup()
{
    // 初期状態を退避
    m_Flag = m_pBone->ref().flag & (ResBone::VISIBILITY | ResBone::BILLBOARD_MASK);
}

void EditBone::Cleanup()
{
    // 初期状態に戻す
    bit32 clearFlag = VISIBILITY_CLEAR_MASK | BILLBOARD_CLEAR_MASK;
    m_pBone->ref().flag &= clearFlag;
    m_pBone->ref().flag |= m_Flag;
}

void EditBone::SetBillboardFlag(bit32 flag)
{
    m_pBone->ref().flag &= BILLBOARD_CLEAR_MASK;
    m_pBone->ref().flag |= flag;
}

void EditBone::SetVisibilityFlag(bool enable)
{
    m_pBone->ref().flag &= VISIBILITY_CLEAR_MASK;
    if (enable)
    {
        m_pBone->ref().flag |= ResBone::VISIBILITY;
    }
}

}}}} // namespace nw::g3d::edit::detail

#endif // NW_G3D_CONFIG_USE_HOSTIO
