﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/g3d/edit/g3d_EditDefs.h>

#if NW_G3D_CONFIG_USE_HOSTIO

#include <nw/g3d/edit/detail/g3d_EditDetailDefs.h>
#include "g3d_EditSocket.h"
#include "g3d_EditHostFileIO.h"
#include "ut/g3d_EditWorkBuffer.h"

namespace nw {
namespace g3d {
namespace edit {

class IAllocator;

namespace detail {

class CommandMonitor
{
    NW_G3D_DISALLOW_COPY_AND_ASSIGN( CommandMonitor );

public:
    struct InitArg
    {
        nw::g3d::edit::IAllocator*         pAllocator;
#if ORE_IS_HOST_CAFE
        FSClient*               pHostFileIOHandle;
#endif
        explicit InitArg()
            : pAllocator(NULL)
#if ORE_IS_HOST_CAFE
            , pHostFileIOHandle(NULL)
#endif
        {}
    };

    struct ProcessCommandArg
    {
        CommandFlag command;
        void* pWorkBuffer;
        int workBufferSize;
    };

    struct AnalyzeCommandArg
    {
        CommandFlag command;
        void* pWorkBuffer;
        int workBufferSize;
    };

public:
    typedef void (*Callback)();
    explicit CommandMonitor(
        bool (*pAnalyzeCommandCallback)(AnalyzeCommandArg&),
        bool (*pProcessCommandCallback)(ProcessCommandArg&));
    ~CommandMonitor() throw();

    bool Initialize(const InitArg& arg);

    bool Open();
    void Close();

    bool IsConnected() const;

    bool IsOpened() const
    {
        return m_IsHostIoOpened;
    }

    // TODO: GetSocketで行っている処理をこのクラスが行うようにする
    EditSocket& GetSocket()
    {
        return m_Socket;
    }

    bool PollDataCommunication();
    bool PollDataEdit();
    void PollSocket();

    void ClearState();
    bool AnalyzePacket();

    bool SendBeginFreeze();
    bool SendEndFreeze();

    void* GetWorkBuffer()
    {
        return m_pWorkBuffer->GetWorkBufferPtr();
    }

    int GetWorkBufferSize() const
    {
        return m_pWorkBuffer->Size();
    }

    void ClearWorkBuffer();

private:
    // Poll 処理用状態の列挙型
    enum PollState
    {
        kReady,
        kPacketAnalyzing,
        kCommandAnalyzing,
        kCommandProcessing
    };

    // ファイル処理用状態の列挙型
    enum FileLoadState
    {
        kBegin,     // 処理開始
        kLooping,   // 複数ファイルループ処理中
        kLoading,   // ファイルロード中
        kLoadedAll, // 全ての複数ファイルロード終了
        kEnd        // 処理終了
    };

private:
    void TryResizeWorkBuffer(int bufferSize);
    void ExecuteFileLoadCommand();

private:
    nw::g3d::edit::IAllocator* m_pAllocator;
    nw::g3d::edit::ut::detail::EditWorkBuffer* m_pWorkBuffer;

    EditSocket        m_Socket;
    PacketHeader     m_PacketHeader;
    PacketHeader      m_PacketErrorHeader;
    PacketHeader      m_SendPacketHeader;

    volatile PollState        m_PollState;
    volatile FileLoadState    m_FileLoadState;
    volatile int                    m_FileLoadIndex;
    volatile bool           m_IsReadStarted;
    volatile bool           m_IsCommandAnalyzing;
    bool m_IsHostIoOpened;

    bool (*m_pAnalyzeCommandCallback)(AnalyzeCommandArg&);
    bool (*m_pProcessCommandCallback)(ProcessCommandArg&);
};

}}}} // namespace evfl::edit::internal

#endif // EVFL_CONFIG_USE_HOSTIO
