﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_SystemThreadDefinition.h>

#include <nn/ndd/detail/ndd_Utility.h>
#include <nn/ndd/detail/ndd_Queue.h>

namespace nn { namespace ndd { namespace wlan { namespace scan {

namespace {

//スレッド
const size_t ThreadStackSize = 4096;
NN_OS_ALIGNAS_THREAD_STACK char  g_ThreadStackForScan[ThreadStackSize];
nn::os::ThreadType  g_ScanThread;

Message g_Message;

//停止指示。停止同期は現状スレッド破棄
nn::os::EventType g_StartEvent;
nn::os::EventType g_CancelEvent;
}

void ScanThread(void* arg)
{
    for(;;)
    {
        nn::os::WaitEvent(&g_StartEvent);
        NN_NDD_LOG("Scan started\n");
        static const int ScanTimeSecond = 3;
        nn::os::TimedWaitEvent(&g_CancelEvent, nn::TimeSpan::FromSeconds(ScanTimeSecond));

        g_Message.Set(ApiId_System_DeviceScanFinished);
        queue::EnQueue(g_Message);
    }
}

void Initialize()
{
    nn::os::InitializeEvent(&g_StartEvent, false, nn::os::EventClearMode_AutoClear);
    nn::os::InitializeEvent(&g_CancelEvent, false, nn::os::EventClearMode_AutoClear);

    auto result = nn::os::CreateThread( &g_ScanThread, ScanThread, nullptr, g_ThreadStackForScan, ThreadStackSize, NN_SYSTEM_THREAD_PRIORITY(ndd, Scanner));
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    nn::os::SetThreadNamePointer(&g_ScanThread, NN_SYSTEM_THREAD_NAME(ndd, Scanner));
    nn::os::StartThread(&g_ScanThread);
}

void Start()
{
    nn::os::SignalEvent(&g_StartEvent);
}

void Cancel()
{
    nn::os::SignalEvent(&g_CancelEvent);
}

}}}}
