﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/sf_NativeHandle.h>

namespace nn { namespace manu {

class UfioRequest
{
public:
    void InitializeForUfio(uint32_t portNumber) NN_NOEXCEPT;
    nn::Result GetFileSize(const nn::sf::Out<uint64_t>& pOutData, const nn::sf::InArray<char>& path) NN_NOEXCEPT;
    nn::Result ReadFromHost(const nn::sf::OutBuffer& pOutBuffer, uint64_t bufferSize, const nn::sf::InArray<char>& path, uint64_t offset, uint64_t readSize) NN_NOEXCEPT;
    nn::Result WriteToHost(const nn::sf::InBuffer& pBuffer, uint64_t bufferSize, const nn::sf::InArray<char>& path, uint64_t offset, uint64_t writeSize) NN_NOEXCEPT;

    void InitializeForUsbTransfer(uint32_t portNumber) NN_NOEXCEPT;
    nn::Result UsbRead(const nn::sf::Out<uint64_t>& pOutSuccessReadSize , const nn::sf::OutBuffer& pOutBuffer, uint64_t bufferSize, uint64_t readSize) NN_NOEXCEPT;
    nn::Result UsbWrite(const nn::sf::Out<uint64_t>& pOutSuccessWriteSize , const nn::sf::InBuffer& pBuffer, uint64_t bufferSize, uint64_t writeSize) NN_NOEXCEPT;
};

}}
