﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "manu_UfioRequestImpl.h"
#include "detail/manu_Request.h"
#include "detail/manu_UsbHostCommunicator.h"

namespace nn { namespace manu {

void UfioRequest::InitializeForUfio(uint32_t portNumber) NN_NOEXCEPT
{
    return nn::manu::detail::InitializeForUfio(portNumber);
}

nn::Result UfioRequest::GetFileSize(const nn::sf::Out<uint64_t>& pOutData, const nn::sf::InArray<char>& path) NN_NOEXCEPT
{
    uint64_t fileSize = 0;
    auto result = nn::manu::detail::GetFileSize(reinterpret_cast<size_t*>(&fileSize), path.GetData());
    pOutData.Set(fileSize);

    return result;
}

nn::Result UfioRequest::ReadFromHost(const nn::sf::OutBuffer& pOutBuffer, uint64_t bufferSize, const nn::sf::InArray<char>& path, uint64_t offset, uint64_t readSize) NN_NOEXCEPT
{
    return nn::manu::detail::ReadFromHost(pOutBuffer.GetPointerUnsafe(), bufferSize, path.GetData(), offset, readSize);
}

nn::Result UfioRequest::WriteToHost(const nn::sf::InBuffer& pBuffer, uint64_t bufferSize, const nn::sf::InArray<char>& path, uint64_t offset, uint64_t writeSize) NN_NOEXCEPT
{
    return nn::manu::detail::WriteToHost(pBuffer.GetPointerUnsafe(), bufferSize, path.GetData(), offset, writeSize);
}

void UfioRequest::InitializeForUsbTransfer(uint32_t portNumber) NN_NOEXCEPT
{
    return nn::manu::detail::InitializeForUsbTransfer(portNumber);
}

nn::Result UfioRequest::UsbRead(const nn::sf::Out<uint64_t>& pOutSuccessReadSize, const nn::sf::OutBuffer& pOutBuffer, uint64_t bufferSize, uint64_t readSize) NN_NOEXCEPT
{
    uint64_t successReadSize = 0;
    auto result = nn::manu::detail::UsbRead(reinterpret_cast<size_t*>(&successReadSize), pOutBuffer.GetPointerUnsafe(), bufferSize, readSize);
    pOutSuccessReadSize.Set(successReadSize);

    return result;
}

nn::Result UfioRequest::UsbWrite(const nn::sf::Out<uint64_t>& pOutSuccessWriteSize, const nn::sf::InBuffer& pBuffer, uint64_t bufferSize, uint64_t writeSize) NN_NOEXCEPT
{
    uint64_t successWriteSize = 0;
    auto result = nn::manu::detail::UsbWrite(reinterpret_cast<size_t*>(&successWriteSize), pBuffer.GetPointerUnsafe(), bufferSize, writeSize);
    pOutSuccessWriteSize.Set(successWriteSize);

    return result;
}

}}
