﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ldn/detail/Debug/ldn_Log.h>
#include <nn/ldn/detail/Service/ldn_MonitorService.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace ldn { namespace detail
{
    MonitorService::MonitorService(Core* pCore) NN_NOEXCEPT
        : m_pCore(pCore)
    {
        NN_SDK_ASSERT_NOT_NULL(pCore);
    }

    MonitorService::~MonitorService() NN_NOEXCEPT
    {
    }

    Result MonitorService::Initialize() NN_NOEXCEPT
    {
        NN_LDN_TRACE;
        NN_RESULT_SUCCESS;
    }

    Result MonitorService::Finalize() NN_NOEXCEPT
    {
        NN_LDN_TRACE;
        NN_RESULT_SUCCESS;
    }

    Result MonitorService::GetState(nn::sf::Out<Bit32> pOutState) const NN_NOEXCEPT
    {
        NN_LDN_TRACE;
        *pOutState = static_cast<Bit32>(m_pCore->GetState());
        NN_RESULT_SUCCESS;
    }

    Result MonitorService::GetNetworkInfo(
        nn::sf::Out<NetworkInfo> pOutNetwork) const NN_NOEXCEPT
    {
        NN_LDN_TRACE;
        return m_pCore->GetNetworkInfo(pOutNetwork.GetPointer());
    }

    Result MonitorService::GetIpv4Address(
        nn::sf::Out<Ipv4Address> pOutAddress,
        nn::sf::Out<SubnetMask> pOutMask) const NN_NOEXCEPT
    {
        NN_LDN_TRACE;
        return m_pCore->GetIpv4Address(pOutAddress.GetPointer(), pOutMask.GetPointer());
    }

    Result MonitorService::GetDisconnectReason(nn::sf::Out<int16_t> pOutReason) const NN_NOEXCEPT
    {
        NN_LDN_TRACE;
        NN_UNUSED(pOutReason);
        NN_RESULT_SUCCESS;
    }

    Result MonitorService::GetSecurityParameter(
        nn::sf::Out<SecurityParameter> pOutSecurityParameter) const NN_NOEXCEPT
    {
        NN_LDN_TRACE;
        return m_pCore->GetSecurityParameter(pOutSecurityParameter.GetPointer());
    }

    Result MonitorService::GetNetworkConfig(
        nn::sf::Out<NetworkConfig> pOutNetworkConfig) const NN_NOEXCEPT
    {
        NN_LDN_TRACE;
        return m_pCore->GetNetworkConfig(pOutNetworkConfig.GetPointer());
    }

}}} // namespace nn::ldn::detail
