﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <algorithm>
#include <nn/ldn/ldn_Result.h>
#include <nn/ldn/ldn_Types.h>
#include <nn/ldn/detail/Debug/ldn_Log.h>
#include <nn/ldn/detail/NetworkInterface/ldn_NetworkInterfaceBase.h>

namespace nn { namespace ldn { namespace detail { namespace
{

}}}} // namespace nn::ldn::detail::<unnamed>

namespace nn { namespace ldn { namespace detail
{
    NetworkInterfaceBase::NetworkInterfaceBase() NN_NOEXCEPT
    {
    }

    NetworkInterfaceBase::~NetworkInterfaceBase() NN_NOEXCEPT
    {
    }

    bool NetworkInterfaceBase::IsSupportedChannel(int channel) const NN_NOEXCEPT
    {
        NetworkInterfaceProfile profile;
        GetNetworkInterfaceProfile(&profile);
        for (int i = 0; i < profile.supportedChannelCount; ++i)
        {
            if (profile.supportedChannels[i] == channel)
            {
                return true;
            }
        }
        return false;
    }

    bool NetworkInterfaceBase::IsAutoSelectableChannel(int channel) const NN_NOEXCEPT
    {
        NetworkInterfaceProfile profile;
        GetNetworkInterfaceProfile(&profile);
        for (int i = 0; i < profile.autoSelectableChannelCount; ++i)
        {
            if (profile.autoSelectableChannels[i] == channel)
            {
                return true;
            }
        }
        return false;
    }

    int NetworkInterfaceBase::GetLinkLevel() const NN_NOEXCEPT
    {
        // 現在の接続状態を取得します。
        L2State status = GetState();

        // リンクレベルの計算方法はアクセスポイントとステーションで異なります。
        int rssi = RssiMin;
        if (status == L2State_AccessPointCreated)
        {
            // 全 STA について STA-AP 間の RSSI を取得し、最小値からリンクレベルを計算します。
            int count;
            int minRssi = 0;
            L2StationInfo stations[StationCountMax];
            if (GetStations(stations, &count, StationCountMax).IsSuccess())
            {
                for (auto& station : stations)
                {
                    if (station.status == L2StationState_Connected)
                    {
                        minRssi = std::min(minRssi, static_cast<int>(station.rssi));
                    }
                }
            }
            rssi = minRssi;
        }
        else if (status == L2State_StationConnected)
        {
            // 自身と AP の間の RSSI からリンクレベルを計算します。
            L2StationInfo station;
            if (GetConnectionStatus(&station).IsSuccess())
            {
                rssi = station.rssi;
            }
        }

        // RSSI を LinkLevel に変換します。
        int linkLevel = ConvertRssiToLinkLevel(rssi);
        NN_SDK_ASSERT_MINMAX(linkLevel, LinkLevelMin, LinkLevelMax);
        return linkLevel;
    }

}}} // namespace nn::ldn::detail
