﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/hid/hid_Keyboard.h>
#include <nn/kpr/kpr_KeyCode.h>
#include <nn/kpr/detail/kpr_KeyCodeMap.h>

namespace nn { namespace kpr { namespace detail {

//!< キー入力の文字コード変換表の変換モードを表す列挙型です。
enum class KeyCodeMapInternalMode
{
    Default,    //!< 既定
    Hiragana,   //!< かな入力（ひらがな）
    Katakana,   //!< かな入力（カタカナ）
    Cyrillic,   //!< キリル文字入力
    Hangul,     //!< ハングル入力
    Zhuyin,     //!< 注音入力
    Cangjie,    //!< 倉頡入力
};

//!< キー入力の文字コード変換表が指定された変換モードをサポートするか否かを表す値を返します。
bool IsKeyCodeMapModeSupported(
    const KeyCodeMapStorage& map, KeyCodeMapInternalMode mode) NN_NOEXCEPT;

//!< キー入力の HID Usage ID に対応する文字コードを取得します。
void GetKeyCode(
    KeyCode* pOutValue,
    int usageId, ::nn::hid::KeyboardModifierSet modifiers,
    const KeyCodeMapStorage& map, KeyCodeMapInternalMode mode) NN_NOEXCEPT;

}}} // namespace nn::kpr::detail
