﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/hid/hid_Npad.h>
#include <nn/irsensor/irsensor_IrCameraTypes.h>

namespace nn { namespace irsensor { namespace detail {

const int IrCameraCountMax = 4;

//!< IR センサーが搭載されたデバイスの種別の定義です。
enum class IrSensorDeviceType : int8_t
{
    Npad,
    TypeCount,
};

void MakeIrCameraHandle(
    IrCameraHandle* outValue,
    const ::nn::hid::NpadIdType& npadIdType) NN_NOEXCEPT;

IrSensorDeviceType GetIrCameraHandleDeviceType(
    const IrCameraHandle& handle) NN_NOEXCEPT;

int GetIrCameraHandlePlayerNumber(
    const IrCameraHandle& handle) NN_NOEXCEPT;

}}} // namespace nn::irsensor::detail
