﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/hidbus/hidbus_IHidbusServer.sfdl.h>
#include <nn/sf/sf_Buffers.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/sf/sf_NativeHandle.h>

#include "hidbus_SchedulerTask.h"
#include "hidbus_ResourceHolder.h"

namespace nn { namespace hidbus { namespace server {

//!< hidbus サービスを扱うクラスです。
class HidbusServer final
{
    NN_DISALLOW_COPY(HidbusServer);
    NN_DISALLOW_MOVE(HidbusServer);

public:
    HidbusServer() NN_NOEXCEPT;

    ~HidbusServer() NN_NOEXCEPT;
    nn::Result GetBusHandle(nn::sf::Out<nn::hidbus::BusHandle> outHandle, nn::sf::Out<bool> hasHandle, std::uint32_t npadId, std::uint64_t busTypeId,
                            nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result IsExternalDeviceConnected(nn::sf::Out<bool> isAttached, nn::hidbus::BusHandle handle) NN_NOEXCEPT;
    nn::Result Initialize(nn::hidbus::BusHandle handle, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result Finalize(nn::hidbus::BusHandle handle, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result EnableExternalDevice(nn::hidbus::BusHandle handle, bool isEnabled, std::uint64_t version, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result GetExternalDeviceId(nn::sf::Out<std::uint32_t> deviceId, nn::hidbus::BusHandle handle) NN_NOEXCEPT;
    nn::Result SendCommandAsync(const nn::sf::InBuffer& inData, nn::hidbus::BusHandle handle) NN_NOEXCEPT;
    nn::Result GetSendCommandAsynceResult(nn::sf::Out<std::uint32_t> outSize, const nn::sf::OutBuffer& outData, nn::hidbus::BusHandle handle) NN_NOEXCEPT;
    nn::Result SetEventForSendCommandAsycResult(nn::sf::Out<nn::sf::NativeHandle> attachmentDataReceiveEventHandle, nn::hidbus::BusHandle handle) NN_NOEXCEPT;
    nn::Result GetSharedMemoryHandle(nn::sf::Out<nn::sf::NativeHandle> outValue) NN_NOEXCEPT;
    nn::Result EnableJoyPollingReceiveMode(const nn::sf::InBuffer& inData,
                                        nn::sf::NativeHandle&& transferMemoryHandle, std::uint32_t transferMemorySize,
                                        std::uint32_t mode, nn::hidbus::BusHandle handle) NN_NOEXCEPT;
    nn::Result DisableJoyPollingReceiveMode(nn::hidbus::BusHandle handle) NN_NOEXCEPT;

    // Windows 向けに DFC で PollingData を取得する機能です。
    nn::Result GetPollingData(const nn::sf::OutArray<nn::hidbus::JoyPollingReceivedData>& pOutArray, nn::hidbus::BusHandle handle) NN_NOEXCEPT;

};

//!< hidbus サービスのプロクシを作成します。
::nn::Result CreateHidbusServerProxy(
    ::nn::sf::SharedPointer<IHidbusServer>* outValue) NN_NOEXCEPT;

}}} // namespace nn::hidbus::detail
