﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using Nintendo.ServiceFramework.Applet;
using nn;
using nn.sf;
using std;

namespace nn.applet
{
    [CppRefPath(@"<nn/applet/applet_FundamentalTypes.h>")]
    [ExternalStruct(8, 8)]
    public struct AppletResourceUserId
    {
    }

    [CppRefPath(@"<nn/applet/applet_FundamentalTypes.h>")]
    [CheckAppletResourceUserId]
    [CppFullName("nn::applet::AppletResourceUserId")]
    [ExternalStruct(8, 8)]
    public struct CheckedAppletResourceUserId
    {
    }
}

namespace nn.util
{
    [CppRefPath(@"<nn/util/util_MathTypes.h>")]
    [ExternalStruct(4, 4)]
    public struct Color4u8Type
    {
    }
}

namespace nn.hid
{
    [CppRefPath(@"<nn/hid/hid_JoyXpad.h>")]
    [ExternalStruct(4, 4)]
    public struct JoyXpadId
    {
    }

    [CppRefPath(@"<nn/hid/hid_TouchScreen.h>")]
    [ExternalStruct(40, 8)]
    public struct TouchState
    {
    }

    [CppRefPath(@"<nn/hid/hid_Xpad.h>")]
    [ExternalStruct(4, 4)]
    public struct BasicXpadId
    {
    }

    [CppRefPath(@"<nn/hid/hid_NpadCommonTypes.h>")]
    [ExternalStruct(4, 4)]
    public struct NpadIdType
    {
    }

    [CppRefPath(@"<nn/hid/hid_SixAxisSensor.h>")]
    [ExternalStruct(4, 4)]
    public struct SixAxisSensorHandle
    {
    }

    [CppRefPath(@"<nn/hid/hid_ConsoleSixAxisSensor.h>")]
    [ExternalStruct(4, 4)]
    public struct ConsoleSixAxisSensorHandle
    {
    }

    namespace debug
    {
        [CppRefPath(@"<nn/hid/debug/hid_CaptureButton.h>")]
        [ExternalStruct(8, 8)]
        public struct CaptureButtonAutoPilotState
        {
        }

        [CppRefPath(@"<nn/hid/debug/hid_ConsoleSixAxisSensor.h>")]
        [ExternalStruct(40, 8)]
        public struct ConsoleSixAxisSensorCountState
        {
        }

        [CppRefPath(@"<nn/hid/debug/hid_DebugPad.h>")]
        [ExternalStruct(24, 8)]
        public struct DebugPadAutoPilotState
        {
        }

        [CppRefPath(@"<nn/hid/debug/hid_FirmwareUpdate.h>")]
        [ExternalStruct(16, 1)]
        public struct FirmwareVersion
        {
        }

        [CppRefPath(@"<nn/hid/debug/hid_HomeButton.h>")]
        [ExternalStruct(8, 8)]
        public struct HomeButtonAutoPilotState
        {
        }

        [CppRefPath(@"<nn/hid/debug/hid_Keyboard.h>")]
        [ExternalStruct(40, 8)]
        public struct KeyboardAutoPilotState
        {
        }

        [CppRefPath(@"<nn/hid/debug/hid_Mouse.h>")]
        [ExternalStruct(28, 4)]
        public struct MouseAutoPilotState
        {
        }

        [CppRefPath(@"<nn/hid/debug/hid_SleepButton.h>")]
        [ExternalStruct(8, 8)]
        public struct SleepButtonAutoPilotState
        {
        }

        [CppRefPath(@"<nn/hid/debug/hid_Xpad.h>")]
        [ExternalStruct(28, 4)]
        public struct BasicXpadAutoPilotState
        {
        }
        [CppRefPath(@"<nn/hid/debug/hid_AbstractedPad.h>")]
        [ExternalStruct(8, 8)]
        public struct AbstractedPadHandle
        {
        }
        [CppRefPath(@"<nn/hid/debug/hid_AbstractedPad.h>")]
        [ExternalStruct(152, 8)]
        public struct AbstractedPadState
        {
        }
        [CppRefPath(@"<nn/hid/debug/hid_AbstractedPad.h>")]
        [ExternalStruct(1, 1)]
        public struct AbstractedVirtualPadId
        {
        }
    }

    namespace system
    {
        [CppRefPath(@"<nn/hid/system/hid_NpadCommon.h>")]
        [ExternalStruct(4, 4)]
        public struct NpadDeviceTypeSet
        {
        }

        [CppRefPath(@"<nn/hid/system/hid_UniquePad.h>")]
        [ExternalStruct(8, 8)]
        public struct UniquePadId
        {
        }

        [CppRefPath(@"<nn/hid/system/hid_RegisteredDevice.h>")]
        [ExternalStruct(104, 8)]
        public struct RegisteredDevice
        {
        }

        [CppRefPath(@"<nn/hid/system/hid_FirmwareUpdate.h>")]
        [ExternalStruct(8, 8)]
        public struct FirmwareUpdateDeviceHandle
        {
        }

        [CppRefPath(@"<nn/hid/system/hid_FirmwareUpdate.h>")]
        [ExternalStruct(4, 1)]
        public struct FirmwareUpdateState
        {
        }
    }

    namespace detail
    {
        [CppRefPath(@"<nn/hid/detail/hid_PadTypes.h>")]
        [ExternalStruct(32, 8)]
        public struct PadDriverState
        {
        }
        [CppRefPath(@"<nn/hid/detail/hid_SensorTypes.h>")]
        [ExternalStruct(32, 8)]
        public struct SixAxisSensorDriverState
        {
        }
        [CppRefPath(@"<nn/hid/detail/hid_RxPacketHistoryTypes.h>")]
        [ExternalStruct(24, 8)]
        public struct RxPacketHistory
        {
        }
    }

    [CppRefPath(@"<nn/hid/hid_IHidDebugServer.sfdl.h>")]
    public interface IHidDebugServer : IServiceObject
    {
        // 0- : DebugPad

        [MethodId(0)]
        Result DeactivateDebugPad();

        [MethodId(1)]
        Result SetDebugPadAutoPilotState(debug.DebugPadAutoPilotState value);

        [MethodId(2)]
        Result UnsetDebugPadAutoPilotState();

        // 10- : TouchScreen

        [MethodId(10)]
        Result DeactivateTouchScreen();

        [MethodId(11)]
        Result SetTouchScreenAutoPilotState(
            [BufferTransferMode(BufferTransferMode.MapAlias)]
            InArray<TouchState> touches);

        [MethodId(12)]
        Result UnsetTouchScreenAutoPilotState();

        // 20- : Mouse

        [MethodId(20)]
        Result DeactivateMouse();

        [MethodId(21)]
        Result SetMouseAutoPilotState(debug.MouseAutoPilotState value);

        [MethodId(22)]
        Result UnsetMouseAutoPilotState();

        // 30- : Keyboard

        [MethodId(30)]
        Result DeactivateKeyboard();

        [MethodId(31)]
        Result SetKeyboardAutoPilotState(debug.KeyboardAutoPilotState value);

        [MethodId(32)]
        Result UnsetKeyboardAutoPilotState();

        // 50- : Xpad

        [MethodId(50)]
        Result DeactivateXpad(BasicXpadId xpadId);

        [MethodId(51)]
        Result SetXpadAutoPilotState(BasicXpadId xpadId,
                                     debug.BasicXpadAutoPilotState value);

        [MethodId(52)]
        Result UnsetXpadAutoPilotState(BasicXpadId xpadId);

        [MethodId(60)]
        Result DeactivateJoyXpad(JoyXpadId xpadId);

        [MethodId(91)]
        Result DeactivateGesture();

        // 110- : HomeButton

        [MethodId(110)]
        Result DeactivateHomeButton();

        [MethodId(111)]
        Result SetHomeButtonAutoPilotState(
            debug.HomeButtonAutoPilotState value);

        [MethodId(112)]
        Result UnsetHomeButtonAutoPilotState();

        // 120- : SleepButton

        [MethodId(120)]
        Result DeactivateSleepButton();

        [MethodId(121)]
        Result SetSleepButtonAutoPilotState(
            debug.SleepButtonAutoPilotState value);

        [MethodId(122)]
        Result UnsetSleepButtonAutoPilotState();

        [MethodId(123)]
        Result DeactivateInputDetector();

        // 130- : CaptureButton, Calibration

        [MethodId(130)]
        Result DeactivateCaptureButton();

        [MethodId(131)]
        Result SetCaptureButtonAutoPilotState(
            debug.CaptureButtonAutoPilotState value);

        [MethodId(132)]
        Result UnsetCaptureButtonAutoPilotState();

        [MethodId(133)]
        Result SetShiftAccelerometerCalibrationValue(nn.hid.SixAxisSensorHandle handle,
                                                     nn.applet.CheckedAppletResourceUserId aruid,
                                                     float shiftOrigin,
                                                     float shiftSensitivity);

        [MethodId(134)]
        Result GetShiftAccelerometerCalibrationValue(Out<float> shiftOrigin,
                                                     Out<float> shiftSensitivity,
                                                     nn.hid.SixAxisSensorHandle handle,
                                                     nn.applet.CheckedAppletResourceUserId aruid);

        [MethodId(135)]
        Result SetShiftGyroscopeCalibrationValue(nn.hid.SixAxisSensorHandle handle,
                                                 nn.applet.CheckedAppletResourceUserId aruid,
                                                 float shiftOrigin,
                                                 float shiftSensitivity);

        [MethodId(136)]
        Result GetShiftGyroscopeCalibrationValue(Out<float> shiftOrigin,
                                                 Out<float> shiftSensitivity,
                                                 nn.hid.SixAxisSensorHandle handle,
                                                 nn.applet.CheckedAppletResourceUserId aruid);

        // 140- : ConsoleSixAxisSensor

        [MethodId(140)]
        Result DeactivateConsoleSixAxisSensor();

        [MethodId(141)]
        Result GetConsoleSixAxisSensorSamplingFrequency(Out<int64_t> outValue,
                                                        nn.applet.CheckedAppletResourceUserId aruid);

        [MethodId(142)]
        Result DeactivateSevenSixAxisSensor();

        [MethodId(143)]
        Result GetConsoleSixAxisSensorCountStates(
            Out<int> outCount,
            [AutoSelectBuffer] OutArray<nn.hid.debug.ConsoleSixAxisSensorCountState> pOutStates,
            nn.applet.CheckedAppletResourceUserId aruid);

        // 200- : FirmwareUpdate

        [MethodId(201)]
        Result ActivateFirmwareUpdate();

        [MethodId(202)]
        Result DeactivateFirmwareUpdate();

        [MethodId(203)]
        Result StartFirmwareUpdate(
            nn.hid.system.UniquePadId id);

        [MethodId(204)]
        Result GetFirmwareUpdateStage(
            Out<int64_t> outStage,
            Out<int64_t> outProgress);

        // DevMenu 用
        [MethodId(205)]
        Result GetFirmwareVersion(
            Out<nn.hid.debug.FirmwareVersion> outValue,
            nn.hid.NpadIdType id,
            nn.hid.system.NpadDeviceTypeSet deviceType);

        // DevMenu 用
        [MethodId(206)]
        Result GetDestinationFirmwareVersion(
            Out<nn.hid.debug.FirmwareVersion> outValue,
            nn.hid.NpadIdType id,
            nn.hid.system.NpadDeviceTypeSet deviceType);

        [MethodId(207)]
        Result DiscardFirmwareInfoCacheForRevert();

        [MethodId(208)]
        Result StartFirmwareUpdateForRevert(
            nn.hid.system.UniquePadId id);

        [MethodId(209)]
        Result GetAvailableFirmwareVersionForRevert(
            Out<nn.hid.debug.FirmwareVersion> outValue,
            nn.hid.system.UniquePadId id);

        [MethodId(210)]
        Result IsFirmwareUpdatingDevice(
            Out<bool> outValue,
            nn.hid.system.UniquePadId id);

        [MethodId(211)]
        Result StartFirmwareUpdateIndividual(
            Out<nn.hid.system.FirmwareUpdateDeviceHandle> outHandle,
            nn.hid.system.UniquePadId id,
            int64_t target,
            NativeHandle imageHandle,
            uint64_t imageSize);

        // 220- : Misc

        [MethodId(221)]
        Result UpdateControllerColor(
            nn.util.Color4u8Type mainColor,
            nn.util.Color4u8Type subColor,
            nn.hid.system.UniquePadId id);

        [MethodId(222)]
        Result ConnectUsbPadsAsync();

        [MethodId(223)]
        Result DisconnectUsbPadsAsync();

        [MethodId(224)]
        Result UpdateDesignInfo(
            nn.util.Color4u8Type mainColor,
            nn.util.Color4u8Type subColor,
            nn.util.Color4u8Type thirdColor,
            nn.util.Color4u8Type forthColor,
            uint32_t variation,
            nn.hid.system.UniquePadId id);

        [MethodId(225)]
        Result GetUniquePadDriverState(
            Out<nn.hid.detail.PadDriverState> outState,
            nn.hid.system.UniquePadId id);

        [MethodId(226)]
        Result GetSixAxisSensorDriverStates(
            Out<int64_t> outCount,
            OutArray<nn.hid.detail.SixAxisSensorDriverState> outStates,
            nn.hid.system.UniquePadId id);

        [MethodId(227)]
        Result GetRxPacketHistory(
            Out<nn.hid.detail.RxPacketHistory> outValue,
            nn.hid.system.UniquePadId id);

        [MethodId(228)]
        Result AcquireSerialFlashEventHandle(
            Out<NativeHandle> outValue,
            nn.hid.system.UniquePadId id);

        [MethodId(229)]
        Result ReadSerialFlash(
            uint32_t address,
            NativeHandle transferMemoryHandle,
            uint64_t transferMemorySize,
            nn.hid.system.UniquePadId id);

        [MethodId(230)]
        Result WriteSerialFlash(
            uint32_t address,
            NativeHandle transferMemoryHandle,
            uint64_t transferMemorySize,
            uint64_t writeSize,
            nn.hid.system.UniquePadId id);

        [MethodId(231)]
        Result GetSerialFlashResult(nn.hid.system.UniquePadId id);

        // 300- : AbstractedPad

        [MethodId(301)]
        Result GetAbstractedPadHandles(Out<int> pOutCount, OutArray<nn.hid.debug.AbstractedPadHandle> pOutHandles);

        [MethodId(302)]
        Result GetAbstractedPadState(Out<nn.hid.debug.AbstractedPadState> pOutState, nn.hid.debug.AbstractedPadHandle handle);

        [MethodId(303)]
        Result GetAbstractedPadsState(
            Out<int> pOutCount,
            OutArray<nn.hid.debug.AbstractedPadHandle> pOutHandles,
            [AutoSelectBuffer] OutArray<nn.hid.debug.AbstractedPadState> pOutStates);

        // 320- : AutoPilot

        [MethodId(321)]
        Result SetAutoPilotVirtualPadState(debug.AbstractedVirtualPadId virtualPadId,
                                     debug.AbstractedPadState value);

        [MethodId(322)]
        Result UnsetAutoPilotVirtualPadState(debug.AbstractedVirtualPadId virtualPadId);

        [MethodId(323)]
        Result UnsetAllAutoPilotVirtualPadState();

        // 350- : RegisteredDevice

        [MethodId(350)]
        Result AddRegisteredDevice(nn.hid.system.RegisteredDevice device);
    }
}
