﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Abort.h>
#include <nn/nn_SdkAssert.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/hid/hid_VibrationFileApi.h>
#include "detail/hid_VibrationFileApiImpl.h"

namespace nn { namespace hid {

Result ParseVibrationFile(
    VibrationFileInfo* pOutInfo,
    VibrationFileParserContext* pOutContext,
    const void* address,
    size_t fileSize) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_NOT_NULL(pOutInfo);
    NN_ABORT_UNLESS_NOT_NULL(pOutContext);
    NN_ABORT_UNLESS_NOT_NULL(address);
    NN_ABORT_UNLESS_GREATER(fileSize, static_cast<size_t>(0));

    ::nn::hid::detail::VibrationFileParserContextImpl& contextImpl = nn::util::Get(pOutContext->_storage).impl;
    NN_RESULT_DO(detail::ParseVibrationFile(pOutInfo, &contextImpl, address, fileSize));

    NN_RESULT_SUCCESS;
}

void RetrieveVibrationValue(
    VibrationValue* pOutValue,
    int position,
    VibrationFileParserContext* pContext) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_NOT_NULL(pOutValue);
    NN_ABORT_UNLESS_NOT_NULL(pContext);

    ::nn::hid::detail::VibrationFileParserContextImpl& contextImpl = nn::util::Get(pContext->_storage).impl;
    NN_ABORT_UNLESS_NOT_NULL(contextImpl.dataAddress);
    NN_ABORT_UNLESS_RANGE(position, 0, contextImpl.sampleLength);

    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::RetrieveVibrationValue(pOutValue, position, &contextImpl));
}

}} // namespace nn::hid
