﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/nn_SdkAssert.h>
#include <nn/hid/hid_Mouse.h>
#include <nn/hid/debug/hid_Mouse.h>

#include "detail/hid_MouseImpl.h"

namespace nn { namespace hid {

void InitializeMouse() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::InitializeMouse());
}

void GetMouseState(MouseState* pOutValue) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::GetMouseState(pOutValue));
}

int GetMouseStates(MouseState outValues[], int count) NN_NOEXCEPT
{
    int gotCount = 0;
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        detail::GetMouseStates(&gotCount, outValues, count));
    return gotCount;
}

}} // namespace nn::hid

namespace nn { namespace hid { namespace debug {

void FinalizeMouse() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(::nn::hid::detail::FinalizeMouse());
}

void SetMouseAutoPilotState(const MouseAutoPilotState& value) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::hid::detail::SetMouseAutoPilotState(value));
}

void UnsetMouseAutoPilotState() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::hid::detail::UnsetMouseAutoPilotState());
}

}}} // namespace nn::hid::debug
