﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/hid/system/hid_Joy.h>
#include <nn/os/os_SystemEvent.h>

#include "detail/hid_JoyImpl.h"

namespace nn { namespace hid { namespace system {

void BindJoyDetachOnBluetoothOffEvent(::nn::os::SystemEventType* pEvent,
                                 ::nn::os::EventClearMode clearMode) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::BindJoyDetachOnBluetoothOffEvent(pEvent, clearMode));
}


}}} // namespace nn::hid::system
