﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/hid/hid_Npad.h>
#include <nn/hid/hid_Result.h>
#include <nn/hid/system/hid_Npad.h>
#include <nn/hid/system/hid_UniquePad.h>
#include <nn/hid/system/hid_FirmwareUpdate.h>

#include "detail/hid_FirmwareUpdateSystemImpl.h"

namespace nn { namespace hid { namespace system {

void InitializeFirmwareUpdate() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::InitializeFirmwareUpdate());
}

::nn::Result StartFirmwareUpdate(system::FirmwareUpdateDeviceHandle* pOutHandle,
                                 UniquePadId id) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutHandle);

    auto result = detail::StartFirmwareUpdate(pOutHandle, id);

    NN_RESULT_THROW(result);
}

void AbortFirmwareUpdate() NN_NOEXCEPT
{
    // 失敗しても特に問題ない (失敗時は実質何もしない) ので Result は返さない。
    // 警告対策のため、result は取得するものの不使用扱い。
    auto result = detail::AbortFirmwareUpdate();
    NN_UNUSED(result);
}

::nn::Result GetFirmwareVersion(FirmwareVersion* pOutVersion,
                                UniquePadId id) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutVersion);

    auto result = detail::GetFirmwareVersion(pOutVersion, id);

    NN_RESULT_THROW(result);
}

::nn::Result GetAvailableFirmwareVersion(FirmwareVersion* pOutVersion,
                                      UniquePadId id) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutVersion);

    auto result = detail::GetAvailableFirmwareVersion(pOutVersion, id);

    NN_RESULT_THROW(result);
}

::nn::Result IsFirmwareUpdateAvailable(bool* pOutIsAvailable,
                                  UniquePadId id) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutIsAvailable);

    auto result = detail::IsFirmwareUpdateAvailable(pOutIsAvailable, id);

    NN_RESULT_THROW(result);
}

::nn::Result CheckFirmwareUpdateRequired(FirmwareUpdateRequiredReason* pOutReason,
                                         UniquePadId id) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutReason);

    auto result = detail::CheckFirmwareUpdateRequired(pOutReason, id);

    NN_RESULT_THROW(result);
}

::nn::Result GetFirmwareUpdateState(FirmwareUpdateState* pOutState,
                                    const FirmwareUpdateDeviceHandle& handle) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutState);

    auto result = detail::GetFirmwareUpdateState(pOutState, handle);

    NN_RESULT_THROW(result);
}

void SetFirmwareHotfixUpdateSkipEnabled(bool isEnabled) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::SetFirmwareHotfixUpdateSkipEnabled(isEnabled));
}

}}} // namespace nn::hid::system
