﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/hid/hid_Npad.h>
#include <nn/hid/hid_Result.h>
#include <nn/hid/system/hid_Npad.h>
#include <nn/hid/system/hid_UniquePad.h>
#include <nn/hid/debug/hid_FirmwareUpdate.h>

#include "detail/hid_FirmwareUpdateDebugImpl.h"

namespace nn { namespace hid { namespace debug {

void InitializeFirmwareUpdate() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::InitializeFirmwareUpdate());
}

::nn::Result StartFirmwareUpdate(system::UniquePadId id) NN_NOEXCEPT
{
    auto result = detail::StartFirmwareUpdate(id);

    NN_RESULT_THROW(result);
}

::nn::Result StartFirmwareUpdateForRevert(system::UniquePadId id) NN_NOEXCEPT
{
    auto result = detail::StartFirmwareUpdateForRevert(id);

    NN_RESULT_THROW(result);
}

::nn::Result StartFirmwareUpdateIndividual(
    system::FirmwareUpdateDeviceHandle* pOutHandle,
    system::UniquePadId id,
    FirmwareUpdateTargetChip target,
    char* pImageData,
    size_t imageSize) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(
        target == FirmwareUpdateTargetChip_Bluetooth ||
        target == FirmwareUpdateTargetChip_Mcu,
        "Unsupported target"
    );
    NN_SDK_REQUIRES_NOT_NULL(pImageData);

    auto result = detail::StartFirmwareUpdateIndividual(pOutHandle, id, target, pImageData, imageSize);

    NN_RESULT_THROW(result);
}

::nn::Result GetFirmwareVersion(FirmwareVersion* pOutValue,
                                NpadIdType id,
                                system::NpadDeviceTypeSet deviceType) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);
    auto result = detail::GetFirmwareVersion(pOutValue, id, deviceType);

    NN_RESULT_THROW(result);
}

::nn::Result GetAvailableFirmwareVersionForRevert(FirmwareVersion* pOutVersion,
                                                  system::UniquePadId id) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutVersion);

    auto result = detail::GetAvailableFirmwareVersionForRevert(pOutVersion, id);

    NN_RESULT_THROW(result);
}

::nn::Result GetDestinationFirmwareVersion(FirmwareVersion* pOutValue,
                                           NpadIdType id,
                                           system::NpadDeviceTypeSet deviceType) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);
    auto result = detail::GetDestinationFirmwareVersion(pOutValue, id, deviceType);

    NN_RESULT_THROW(result);
}

::nn::Result GetFirmwareUpdateStage(FirmwareUpdateStage* pOutStage, uint8_t* pOutProgress) NN_NOEXCEPT
{
    auto result = detail::GetFirmwareUpdateStage(pOutStage, pOutProgress);

    NN_RESULT_THROW(result);
}

::nn::Result IsFirmwareUpdatingDevice(bool* pOutIsUpdating, system::UniquePadId id) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutIsUpdating);
    auto result = detail::IsFirmwareUpdatingDevice(pOutIsUpdating, id);

    NN_RESULT_THROW(result);
}

}}} // namespace nn::hid::debug
