﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/hid/system/hid_AnalogStickManualCalibration.h>
#include <nn/hid/system/hid_Result.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/result/result_HandlingUtility.h>

#include "detail/hid_AnalogStickManualCalibrationImpl.h"
#include "detail/hid_UniquePadImpl.h"

namespace nn { namespace hid { namespace system {

void GetAnalogStickState(AnalogStickState* pOutValue, UniquePadId id, AnalogStickPosition position) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::GetAnalogStickState(pOutValue, id, position));
}

bool IsAnalogStickButtonPressed(UniquePadId id, AnalogStickPosition position) NN_NOEXCEPT
{
    bool outValue;
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::IsAnalogStickButtonPressed(&outValue, id, position));

    return outValue;
}

nn::Result StartAnalogStickManualCalibration(UniquePadId id, AnalogStickPosition position) NN_NOEXCEPT
{
    auto result = detail::StartAnalogStickManualCalibration(id, position);

    NN_RESULT_TRY(result)
        NN_RESULT_CATCH(ResultAnalogStickError)
        {
            NN_RESULT_THROW(result);
        }
    NN_RESULT_END_TRY

    NN_ABORT_UNLESS_RESULT_SUCCESS(result);

    NN_RESULT_SUCCESS;
}

nn::Result GetAnalogStickManualCalibrationStage(AnalogStickManualCalibrationStage* pOutValue, UniquePadId id, AnalogStickPosition position) NN_NOEXCEPT
{
    auto result = detail::GetAnalogStickManualCalibrationStage(pOutValue, id, position);

    NN_RESULT_TRY(result)
        NN_RESULT_CATCH(ResultAnalogStickError)
        {
            NN_RESULT_THROW(result);
        }
    NN_RESULT_END_TRY

    NN_ABORT_UNLESS_RESULT_SUCCESS(result);

    NN_RESULT_SUCCESS;
}

void RetryCurrentAnalogStickManualCalibrationStage(UniquePadId id, AnalogStickPosition position) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::RetryCurrentAnalogStickManualCalibrationStage(id, position));
}

void CancelAnalogStickManualCalibration(UniquePadId id, AnalogStickPosition position) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::CancelAnalogStickManualCalibration(id, position));
}

void ResetAnalogStickManualCalibration(UniquePadId id, AnalogStickPosition position) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::ResetAnalogStickManualCalibration(id, position));
}

bool IsAnalogStickInReleasePosition(UniquePadId id, AnalogStickPosition position) NN_NOEXCEPT
{
    bool outValue;
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::IsAnalogStickInReleasePosition(&outValue, id, position));

    return outValue;
}

bool IsAnalogStickInCircumference(UniquePadId id, AnalogStickPosition position) NN_NOEXCEPT
{
    bool outValue;
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::IsAnalogStickInCircumference(&outValue, id, position));

    return outValue;
}

}}} // namespace nn::hid::system
