﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/hid/hid_IHidServer.sfdl.h>
#include <nn/hid/hid_ResultPrivate.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/sf/sf_NativeHandle.h>

#include "hid_HidServer.h"
#include "hid_XpadImpl.h"

namespace nn { namespace hid { namespace detail {

::nn::Result BindXpadIdEvent(::nn::os::SystemEventType* pEvent,
                             ::nn::os::EventClearMode clearMode) NN_NOEXCEPT
{
    auto pProxy = ::nn::sf::SharedPointer<IHidServer>();
    CreateHidServerProxy(&pProxy);

    auto handle = ::nn::sf::NativeHandle();
    auto clientId = reinterpret_cast<uint64_t>(pEvent);
    NN_RESULT_DO(pProxy->AcquireXpadIdEventHandle(&handle, clientId));

    ::nn::os::AttachReadableHandleToSystemEvent(pEvent,
                                                handle.GetOsHandle(),
                                                handle.IsManaged(),
                                                clearMode);

    // ハンドルの管理権を放棄
    handle.Detach();

    NN_RESULT_SUCCESS;
}

::nn::Result UnbindXpadIdEvent(::nn::os::SystemEventType* pEvent) NN_NOEXCEPT
{
    auto pProxy = ::nn::sf::SharedPointer<IHidServer>();
    CreateHidServerProxy(&pProxy);

    auto clientId = reinterpret_cast<uint64_t>(pEvent);
    ::nn::Result result = pProxy->ReleaseXpadIdEventHandle(clientId);
    if (result.IsSuccess())
    {
        // バインドが解除可能な場合のみ解除
        ::nn::os::DestroySystemEvent(pEvent);
    }
    else if (!ResultXpadIdEventNotBound::Includes(result))
    {
        NN_RESULT_THROW(result);
    }

    NN_RESULT_SUCCESS;
}

}}} // namespace nn::hid::detail
