﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <limits>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_SdkAssert.h>
#include <nn/util/util_BitPack.h>

#include "hid_XpadId.h"

namespace nn { namespace hid { namespace detail {

//<! Xpad ID のビットフィールド定義です。
struct XpadIdField final
{
    //!< Xpad のプレイヤー番号
    typedef ::nn::util::BitPack32::Field<0, 8, int8_t> PlayerNumber;
};

int MakeXpadIdValue(int playerNumber) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_RANGE(
        playerNumber, 0, ::std::numeric_limits<int8_t>::max() + 1);
    auto bitPack = ::nn::util::BitPack32();
    bitPack.Set<XpadIdField::PlayerNumber>(static_cast<int8_t>(playerNumber));
    return bitPack.storage;
}

int GetXpadIdValuePlayerNumber(int storage) NN_NOEXCEPT
{
    ::nn::util::BitPack32 bitPack = { static_cast<uint32_t>(storage) };
    int playerNumber = bitPack.Get<XpadIdField::PlayerNumber>();
    NN_SDK_REQUIRES_RANGE(
        playerNumber, 0, ::std::numeric_limits<int8_t>::max() + 1);
    return playerNumber;
}

}}} // namespace nn::hid::detail
