﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Windows.h>
#include <nn/hid/hid_Mouse.h>

#include "hid_Point.h"
#include "hid_Rectangle.h"

namespace nn { namespace hid { namespace detail {

//!< タッチ入力の最大数
const int TouchInputCountMax = 64;

//!< ウィンドウプロシージャをアクティブ化します。
void ActivateWindowsProcedure() NN_NOEXCEPT;

//!< ウィンドウプロシージャを非アクティブ化します。
void DeactivateWindowsProcedure() NN_NOEXCEPT;

//!< ウィンドウプロシージャを維持します。
bool KeepWindowsProcedureAlive() NN_NOEXCEPT;

//!< サブクラス化されたウィンドウのクライアント領域のサイズを取得します。
bool GetWindowsProcedureClientAreaSize(Rectangle* pOutValue) NN_NOEXCEPT;

//!< ウィンドウプロシージャが観測したマウスの座標を取得します。
bool GetWindowsProcedureMousePosition(Point* pOutValue) NN_NOEXCEPT;

//!< ウィンドウプロシージャが観測したマウスボタンの押下状態を取得します。
MouseButtonSet GetWindowsProcedureMouseButtons() NN_NOEXCEPT;

//!< ウィンドウプロシージャが観測したホイールの回転差分を破壊的に取得します。
int32_t GetWindowsProcedureWheelDelta() NN_NOEXCEPT;

//!< ウィンドウプロシージャが観測したタッチ入力を取得します。
int GetWindowsProcedureTouchInputs(TOUCHINPUT* outBuffer, int count
                                   ) NN_NOEXCEPT;

}}} // namespace nn::hid::detail
