﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/hid/hid_VibrationGcErm.h>

#include "hid_GcAdapterDriver.h"
#include "hid_IVibratorDriver.h"

namespace nn { namespace hid { namespace detail {

class VibratorGcDriver final : public IVibratorDriver
{
private:
    int m_ReferenceCount;
    bool m_IsActivated;
    GcControllerIndex m_Index;
    GcAdapterDriver* m_pDriver;

public:
    VibratorGcDriver() NN_NOEXCEPT :
        m_IsActivated(false)
    {};

    virtual ~VibratorGcDriver() NN_NOEXCEPT NN_OVERRIDE {};
    virtual Result IncreaseReferenceCount() NN_NOEXCEPT NN_OVERRIDE;
    virtual Result DecreaseReferenceCount() NN_NOEXCEPT NN_OVERRIDE;
    virtual void ForceStopVibration() NN_NOEXCEPT NN_OVERRIDE;
    void SetGcAdapterDriver(GcAdapterDriver* pDriver) NN_NOEXCEPT;
    Result ActivateVibrator(GcControllerIndex index) NN_NOEXCEPT;
    Result DeactivateVibrator() NN_NOEXCEPT;
    Result SendCommand(const VibrationGcErmCommand& command) NN_NOEXCEPT;
    Result GetActualCommand(VibrationGcErmCommand* pOutValue) NN_NOEXCEPT;
    Result StartVibrationOnConnect() NN_NOEXCEPT;
};

}}} // namespace nn::hid::detail
