﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_Abort.h>
#include <nn/hid/hid_VibrationDeviceApi.h>
#include <nn/hid/hid_VibrationGcErm.h>
#include "hid_VibrationDeviceHandle.h"

namespace nn { namespace hid { namespace detail {

//!< 一度にまとめて送ることができる VibrationValue の個数の最大値
const int SendableVibrationValueCountMax = 12;

Result PermitVibration(bool isPermitted) NN_NOEXCEPT;
Result IsVibrationPermitted(bool* pOutValue) NN_NOEXCEPT;

Result BeginPermitVibrationSession() NN_NOEXCEPT;
Result EndPermitVibrationSession() NN_NOEXCEPT;

Result InitializeVibrationDevice(const VibrationDeviceHandle& handle) NN_NOEXCEPT;

Result GetVibrationDeviceInfo(VibrationDeviceInfo* pOutValue, const VibrationDeviceHandle& handle) NN_NOEXCEPT;

Result SendVibrationValue(const VibrationDeviceHandle& handle, const VibrationValue& value) NN_NOEXCEPT;

Result SendVibrationValues(const VibrationDeviceHandle* handles, const VibrationValue* values, int valueCount) NN_NOEXCEPT;

Result GetActualVibrationValue(VibrationValue* pOutValue, const VibrationDeviceHandle& handle) NN_NOEXCEPT;

Result SendVibrationGcErmCommand(const VibrationDeviceHandle& handle, const VibrationGcErmCommand& command) NN_NOEXCEPT;

Result GetActualVibrationGcErmCommand(VibrationGcErmCommand* pOutValue, const VibrationDeviceHandle& handle) NN_NOEXCEPT;


}}} // namespace nn::hid::detail
