﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/os/os_SystemEvent.h>

#include <nn/hid/system/hid_AnalogStickManualCalibration.h>
#include <nn/hid/system/hid_SixAxisSensorAccurateCalibration.h>
#include <nn/hid/system/hid_SixAxisSensorCalibration.h>
#include <nn/hid/system/hid_UniquePad.h>
#include <nn/hid/detail/hid_PadTypes.h>
#include <nn/hid/detail/hid_SensorTypes.h>
#include <nn/hid/detail/hid_RxPacketHistoryTypes.h>

namespace nn { namespace hid { namespace detail {

::nn::Result BindUniquePadConnectionEvent(::nn::os::SystemEventType* pEvent,
                                          ::nn::os::EventClearMode clearMode) NN_NOEXCEPT;

::nn::Result ListUniquePads(int* outGotCount,
                            ::nn::hid::system::UniquePadId* outValues,
                            int count) NN_NOEXCEPT;

::nn::Result GetUniquePadType(::nn::hid::system::UniquePadType * pOutValue,
                              ::nn::hid::system::UniquePadId id) NN_NOEXCEPT;

::nn::Result GetUniquePadInterface(::nn::hid::system::UniquePadInterface* pOutValue,
                                   ::nn::hid::system::UniquePadId id) NN_NOEXCEPT;

::nn::Result GetUniquePadControllerNumber(int* pOutValue,
                                          ::nn::hid::system::UniquePadId id) NN_NOEXCEPT;

::nn::Result GetUniquePadSerialNumber(::nn::hid::system::UniquePadSerialNumber *pOutValue,
                                      ::nn::hid::system::UniquePadId id) NN_NOEXCEPT;


::nn::Result GetUniquePadBluetoothAddress(nn::bluetooth::Address *pOutValue, system::UniquePadId id) NN_NOEXCEPT;

::nn::Result DisconnectUniquePad(system::UniquePadId id) NN_NOEXCEPT;

::nn::Result ListSixAxisSensorHandles(int* pOutCount,
                                      system::UniqueSixAxisSensorHandle* pOutValues,
                                      system::UniquePadId id,
                                      int count) NN_NOEXCEPT;

::nn::Result IsSixAxisSensorUserCalibrationSupported(bool* pOutIsSupported,
                                                     system::UniqueSixAxisSensorHandle handle) NN_NOEXCEPT;

::nn::Result ResetSixAxisSensorCalibrationValues(system::UniqueSixAxisSensorHandle handle) NN_NOEXCEPT;

::nn::Result StartSixAxisSensorUserCalibration(system::UniqueSixAxisSensorHandle handle) NN_NOEXCEPT;

::nn::Result GetSixAxisSensorUserCalibrationStage(system::SixAxisSensorUserCalibrationStage* pOutValue,
                                                  system::UniqueSixAxisSensorHandle handle) NN_NOEXCEPT;

::nn::Result CancelSixAxisSensorUserCalibration(system::UniqueSixAxisSensorHandle handle) NN_NOEXCEPT;

::nn::Result GetAnalogStickState(AnalogStickState* pOutValue, system::UniquePadId id, system::AnalogStickPosition position) NN_NOEXCEPT;

::nn::Result GetAnalogStickManualCalibrationStage(system::AnalogStickManualCalibrationStage* pOutValue,
                                                  system::UniquePadId id,
                                                  system::AnalogStickPosition position) NN_NOEXCEPT;

::nn::Result IsAnalogStickButtonPressed(bool* pOutValue, system::UniquePadId id, system::AnalogStickPosition position) NN_NOEXCEPT;

::nn::Result IsAnalogStickInReleasePosition(bool* pOutValue, system::UniquePadId id, system::AnalogStickPosition position) NN_NOEXCEPT;

::nn::Result IsAnalogStickInCircumference(bool* pOutValue, system::UniquePadId id, system::AnalogStickPosition position) NN_NOEXCEPT;

::nn::Result UpdateControllerColor(const ::nn::util::Color4u8Type& mainColor,
                                   const ::nn::util::Color4u8Type& subColor,
                                   const system::UniquePadId& id) NN_NOEXCEPT;

::nn::Result UpdateDesignInfo(const ::nn::util::Color4u8Type& mainColor,
                              const ::nn::util::Color4u8Type& subColor,
                              const ::nn::util::Color4u8Type& thirdColor,
                              const ::nn::util::Color4u8Type& forthColor,
                              uint8_t variation,
                              const system::UniquePadId& id) NN_NOEXCEPT;

::nn::Result ConnectUsbPadsAsync() NN_NOEXCEPT;

::nn::Result DisconnectUsbPadsAsync() NN_NOEXCEPT;

::nn::Result IsSixAxisSensorAccurateUserCalibrationSupported(bool* pOutIsSupported,
                                                             const system::UniqueSixAxisSensorHandle& handle) NN_NOEXCEPT;

::nn::Result StartSixAxisSensorAccurateUserCalibration(const system::UniqueSixAxisSensorHandle& handle) NN_NOEXCEPT;

::nn::Result GetSixAxisSensorAccurateUserCalibrationState(system::SixAxisSensorAccurateUserCalibrationState* pOutValue,
                                                          const system::UniqueSixAxisSensorHandle& handle) NN_NOEXCEPT;

::nn::Result CancelSixAxisSensorAccurateUserCalibration(const system::UniqueSixAxisSensorHandle& handle) NN_NOEXCEPT;

::nn::Result GetUniquePadDriverState(PadDriverState* pOutValue,
                                     const system::UniquePadId& id) NN_NOEXCEPT;

::nn::Result GetSixAxisSensorDriverStates(int* pOutCount,
                                          SixAxisSensorDriverState* outStates,
                                          int count,
                                          const system::UniquePadId& id) NN_NOEXCEPT;

::nn::Result GetRxPacketHistory(RxPacketHistory* pOutValue,
                                const system::UniquePadId& id) NN_NOEXCEPT;

::nn::Result BindSerialFlashEventHandle(
    ::nn::os::SystemEventType* pEvent,
    ::nn::os::EventClearMode clearMode,
    const system::UniquePadId& id) NN_NOEXCEPT;
::nn::Result ReadSerialFlash(
    const uint32_t address,
    uint8_t* pOutBuffer,
    int size,
    const system::UniquePadId& id) NN_NOEXCEPT;
::nn::Result WriteSerialFlash(
    uint32_t address,
    const uint8_t* pBuffer,
    int bufferSize,
    int writeSize,
    const system::UniquePadId& id) NN_NOEXCEPT;
::nn::Result GetSerialFlashResult(const system::UniquePadId& id) NN_NOEXCEPT;

}}} // namespace nn::hid::detail
