﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/os/os_Tick.h>

namespace nn { namespace hid { namespace detail {

struct SixAxisSensorFusionParameters
{
    float stillness;    //!< デバイスの安定度
    float angularError; //!< 姿勢回転から導出される -Z ベクトルと加速度センサから推定される重力加速度ベクトルとのなす角
};

//!< 6 軸センサーのセンサフュージョンポリシー
class SixAxisSensorFusionPolicy
{
    NN_DISALLOW_COPY(SixAxisSensorFusionPolicy);
    NN_DISALLOW_MOVE(SixAxisSensorFusionPolicy);

private:

    //!< センサフュージョンに係る動作モードを表す型
    enum SensorFusionMode
    {
        SensorFusionMode_Idle,
        SensorFusionMode_Still,
    };

    //!< 現在のセンサフュージョンに係る動作モード
    SensorFusionMode m_SensorFusionMode;

    //!< 現在の静止度合い
    float m_Stillness;

    //!< 加速度センサーによる垂直化強度
    float m_VerticalizationStrength;

    //!< 静止状態開始時の tick
    ::nn::os::Tick m_StillStartedTick;

public:

    //!< コンストラクタ
    SixAxisSensorFusionPolicy() NN_NOEXCEPT;

    //!< ポリシーをリセットする
    void Reset() NN_NOEXCEPT;

    //!< ポリシーを更新する
    void Update(const SixAxisSensorFusionParameters& parameters) NN_NOEXCEPT;

    //!< 加速度センサーによる垂直化強度を取得する
    float GetVerticalizationStrength() const NN_NOEXCEPT
    {
        return m_VerticalizationStrength;
    }
};

}}} // namespace nn::hid::detail
