﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/os/os_SystemEvent.h>

#include <nn/hid/system/hid_Irsensor.h>
#include <nn/hid/system/hid_NpadCommon.h>
#include <nn/hid/system/hid_NpadSystem.h>
#include <nn/hid/system/hid_NpadSystemExt.h>
#include <nn/xcd/xcd_Device.h>

namespace nn { namespace hid { namespace detail {

::nn::Result ApplyNpadSystemCommonPolicy() NN_NOEXCEPT;

::nn::Result ApplyNpadSystemCommonPolicyFull() NN_NOEXCEPT;

::nn::Result GetXcdHandleForNpadWithNfc(nn::xcd::DeviceHandle* pOutHandle, NpadIdType& id) NN_NOEXCEPT;

::nn::Result BindNfcActivateEvent(NpadIdType& id,
    ::nn::os::SystemEventType* pEvent,
    ::nn::os::EventClearMode clearMode) NN_NOEXCEPT;

::nn::Result ActivateNfc(NpadIdType& id, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;

::nn::Result DeactivateNfc(NpadIdType& id, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;

::nn::Result IsNfcActivated(bool* pOutIsActivated, NpadIdType& id) NN_NOEXCEPT;

::nn::Result BindIrSensorEvent(NpadIdType& id,
    ::nn::os::SystemEventType* pEvent,
    ::nn::os::EventClearMode clearMode) NN_NOEXCEPT;

::nn::Result GetXcdHandleForNpadWithIrSensor(nn::xcd::DeviceHandle* pOutHandle, NpadIdType& id) NN_NOEXCEPT;

::nn::Result GetIrSensorState(nn::hid::system::IrSensorState* pOutState, NpadIdType& id) NN_NOEXCEPT;

::nn::Result ActivateIrSensor(NpadIdType& id, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;

::nn::Result DeactivateIrSensor(NpadIdType& id, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;

::nn::Result EnableAssigningSingleOnSlSrPress() NN_NOEXCEPT;

::nn::Result DisableAssigningSingleOnSlSrPress() NN_NOEXCEPT;

::nn::Result SetNpadPlayerLedBlinkingDevice(const NpadIdType& id, const system::NpadDeviceTypeSet& deviceType) NN_NOEXCEPT;

::nn::Result GetLastActiveNpadController(NpadIdType* pOutValue) NN_NOEXCEPT;

::nn::Result GetNpadSystemExtStyle(system::NpadSystemExtMainStyle* pOutMainStyle,
                                   system::NpadSystemExtSubStyle* pOutSubStyle,
                                   const NpadIdType& id) NN_NOEXCEPT;

::nn::Result GetUniquePadsFromNpad(int* pOutCount, system::UniquePadId* pOutValues, int count, const NpadIdType& npadId) NN_NOEXCEPT;

::nn::Result GetNpadFullKeyGripColor(nn::util::Color4u8Type* pOutLeftGrip, nn::util::Color4u8Type* pOutRightGrip, const NpadIdType& id) NN_NOEXCEPT;

::nn::Result IsHandheldButtonPressedOnConsoleMode(bool* pOutValue) NN_NOEXCEPT;

::nn::Result GetSupportedNpadStyleSetOfCallerApplet(NpadStyleSet* pOutValue) NN_NOEXCEPT;

}}} // namespace nn::hid::detail
