﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <limits> // for numeric_limits
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/hid/hid_Npad.h>
#include <nn/result/result_HandlingUtility.h>

#include "hid_AbstractedPalmaPad.h"
#include "hid_NpadPalmaScanController.h"

namespace nn { namespace hid { namespace detail {

NpadPalmaScanController::NpadPalmaScanController() NN_NOEXCEPT
    : m_pAppletPolicyManager(nullptr)
    , m_pPalmaResourceManager(nullptr)
{
}

NpadPalmaScanController::~NpadPalmaScanController() NN_NOEXCEPT { /* 何もしない */ }

void NpadPalmaScanController::UpdateScanState() NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(m_pAppletPolicyManager);
    NN_SDK_REQUIRES_NOT_NULL(m_pPalmaResourceManager);

    const auto& policy = m_pAppletPolicyManager->GetCurrentPolicy();
    m_pPalmaResourceManager->SetIsPalmaPairedConnectable(
        policy.GetSupportedNpadStyleSet().Test<NpadStylePalma>()
    );
}

void NpadPalmaScanController::SetNpadAppletPolicyManager(NpadAppletPolicyManager* pManager) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pManager);

    m_pAppletPolicyManager = pManager;
}

void NpadPalmaScanController::SetPalmaResourceManager(PalmaResourceManager* pManager) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pManager);

    m_pPalmaResourceManager = pManager;
}


}}} // namespace nn::hid::detail
