﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/hid/hid_NpadCommonTypes.h>
#include <nn/hid/system/hid_NpadSystem.h>

namespace nn { namespace hid { namespace detail {

inline uint8_t GetIndicatorPattern(NpadIdType id, bool rotate)
{
    const uint8_t IndicatorPattern[] = {0x01, 0x03, 0x07, 0x0f, 0x09, 0x05, 0x0D, 0x06};
    const uint8_t RotateIndicatorPattern[] = {0x08, 0x0c, 0x0e, 0x0f, 0x09, 0x0a, 0x0b, 0x06};

    if (id == NpadId::Handheld || id == system::NpadSystemId::Other)
    {
        return 0;
    }

    const uint8_t* pPattern = (rotate) ? RotateIndicatorPattern : IndicatorPattern;

    switch (id)
    {
    case NpadId::No1:
        return pPattern[0];
    case NpadId::No2:
        return pPattern[1];
    case NpadId::No3:
        return pPattern[2];
    case NpadId::No4:
        return pPattern[3];
    case NpadId::No5:
        return pPattern[4];
    case NpadId::No6:
        return pPattern[5];
    case NpadId::No7:
        return pPattern[6];
    case NpadId::No8:
        return pPattern[7];
    default:
        NN_UNEXPECTED_DEFAULT;
    }
}

}}} // namespace nn::hid::detail
