﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/hid/hid_NpadCommonTypes.h>
#include <nn/hid/system/hid_NpadSystem.h>
#include <nn/hid/hid_ResultPrivate.h>

namespace nn { namespace hid { namespace detail {

//!< サポートしている NpadId のリスト
const NpadIdType SupportedNpadIdList[] = {
                                          NpadId::No1,
                                          NpadId::No2,
                                          NpadId::No3,
                                          NpadId::No4,
                                          NpadId::No5,
                                          NpadId::No6,
                                          NpadId::No7,
                                          NpadId::No8,
                                          NpadId::Handheld,
                                          system::NpadSystemId::Other
                                         };

//!< サポートされている NpadId の最大数
const int NpadIdCountMax = sizeof(SupportedNpadIdList) / sizeof(SupportedNpadIdList[0]);

//!< NpadId が有効かどうかを検証する
inline ::nn::Result VerifyValidNpadId(NpadIdType id) NN_NOEXCEPT
{
    for (auto& npadId : SupportedNpadIdList)
    {
        if (id == npadId)
        {
            NN_RESULT_SUCCESS;
        }
    }

    NN_RESULT_THROW(ResultNpadInvalidId());
}

inline int GetIndexFromNpadIdType(NpadIdType id) NN_NOEXCEPT
{
    if (id <= NpadId::No8)
    {
        return id;
    }
    else if(id == system::NpadSystemId::Other)
    {
        return 9;
    }
    else //if(id == NpadId::Handheld)
    {
        NN_SDK_ASSERT(id == NpadId::Handheld, "Invalid NpadIdType %d have been set", id);
        return 8;
    }
//    NN_ABORT("Invalid NpadIdType have been set");
}

}}} // namespace nn::hid::detail
