﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/hid/hid_IHidSystemServer.sfdl.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/result/result_HandlingUtility.h>

#include "hid_AppletResourceUserId.h"
#include "hid_HidSystemServer.h"
#include "hid_JoyImpl.h"

namespace nn { namespace hid { namespace detail {

::nn::Result BindJoyDetachOnBluetoothOffEvent(::nn::os::SystemEventType* pEvent,
                                             ::nn::os::EventClearMode clearMode) NN_NOEXCEPT
{
    auto pProxy = ::nn::sf::SharedPointer<IHidSystemServer>();
    CreateHidSystemServerProxy(&pProxy);

    auto handle = ::nn::sf::NativeHandle();
    NN_RESULT_DO(pProxy->AcquireJoyDetachOnBluetoothOffEventHandle(&handle, GetAppletResourceUserId()));

    ::nn::os::AttachReadableHandleToSystemEvent(pEvent,
                                                handle.GetOsHandle(),
                                                handle.IsManaged(),
                                                clearMode);

    // ハンドルの管理権を放棄
    handle.Detach();

    NN_RESULT_SUCCESS;
}

}}} // namespace nn::hid::detail
