﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/os/os_SystemEvent.h>

#include "hid_ActivationCount.h"
#include "hid_AppletResourceUserId.h"

namespace nn { namespace hid { namespace detail {

class InterruptSceneNotifier
{
    NN_DISALLOW_COPY(InterruptSceneNotifier);
    NN_DISALLOW_MOVE(InterruptSceneNotifier);

private:
    //!< Bluetooth オフ中のジョイコン取り外し通知するためのシステムイベント
    ::nn::os::SystemEvent m_JoyDetachOnBluetoothOffEvent;

    //!< Bluetooth オフ中のジョイコン取り外し通知を一時的に停止するか
    bool m_IsIgnoreJoyDetachOnBluetoothOffEvent;

public:
    InterruptSceneNotifier() NN_NOEXCEPT;

    //!< Bluetooth オフ中のジョイコン取り外し通知のハンドルを確保します
    ::nn::Result AcquireJoyDetachOnBluetoothOffEventHandle(::nn::os::NativeHandle* pOutValue, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;

    //!< Bluetooth オフ中のジョイコン取り外し通知を一時的に無効化するか設定します。
    void SetIgnoreJoyDetachOnBluetoothOffEvent(bool isIgnore) NN_NOEXCEPT;

    //!< Bluetooth オフ中のジョイコン取り外しを通知します。
    void NotifyJoyDetachOnBluetoothOffEvent() NN_NOEXCEPT;
};

}}} // namespace nn::hid::detail
