﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/hid/hid_ResultPrivate.h>
#include <nn/ovln/ovln_SenderForOverlay.h>
#include <nn/ovln/ovln_FormatForOverlay.h>
#include <nn/result/result_HandlingUtility.h>

#include "hid_ActivationCount.h"
#include "hid_InterruptSceneNotifier.h"

namespace nn { namespace hid { namespace detail {

InterruptSceneNotifier::InterruptSceneNotifier() NN_NOEXCEPT
    : m_JoyDetachOnBluetoothOffEvent(::nn::os::EventClearMode_ManualClear, true)
    , m_IsIgnoreJoyDetachOnBluetoothOffEvent(false)
{
    // 何もしない
}

void InterruptSceneNotifier::SetIgnoreJoyDetachOnBluetoothOffEvent(bool isIgnore) NN_NOEXCEPT
{
    m_IsIgnoreJoyDetachOnBluetoothOffEvent = isIgnore;
}

::nn::Result InterruptSceneNotifier::AcquireJoyDetachOnBluetoothOffEventHandle(::nn::os::NativeHandle* pOutValue, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);
    NN_UNUSED(aruid);

    *pOutValue = m_JoyDetachOnBluetoothOffEvent.GetReadableHandle();

    NN_RESULT_SUCCESS;
}

void InterruptSceneNotifier::NotifyJoyDetachOnBluetoothOffEvent() NN_NOEXCEPT
{
    if (m_IsIgnoreJoyDetachOnBluetoothOffEvent == false)
    {
        m_JoyDetachOnBluetoothOffEvent.Signal();
    }
    m_IsIgnoreJoyDetachOnBluetoothOffEvent = false;
}

}}} // namespace nn::hid::detail
