﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <algorithm>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/hid/hid_ConsoleSixAxisSensor.h>
#include <nn/hid/hid_IHidTemporaryServer.sfdl.h>
#include <nn/hid/tmp/hid_ConsoleSixAxisSensor.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_ObjectFactory.h>
#include <nn/TargetConfigs/build_Base.h>

#include "hid_HidTemporaryServer.h"
#include "hid_Settings.h"
#include "hid_StaticObject.h"

#ifdef NN_BUILD_CONFIG_OS_HORIZON
#include "hid_ResourceManager-os.horizon.h"
#endif

#ifdef NN_BUILD_CONFIG_OS_WIN
#include "hid_ResourceManager-os.win.h"
#endif

namespace nn { namespace hid { namespace detail {

namespace
{
}  // anonymous

HidTemporaryServer::HidTemporaryServer() NN_NOEXCEPT
{
    // 何もしない
}

// 廃止予定
::nn::Result HidTemporaryServer::GetConsoleSixAxisSensorCalibrationValues(nn::sf::Out<nn::hid::tmp::ConsoleSixAxisSensorCalibrationValues> outValue,
                                                                          nn::applet::AppletResourceUserId aruid,
                                                                          nn::hid::ConsoleSixAxisSensorHandle handle) NN_NOEXCEPT
{
    NN_UNUSED(aruid);
    NN_UNUSED(handle);

    ::nn::hid::tmp::ConsoleSixAxisSensorCalibrationValues values = {};

    NN_RESULT_DO(GetResourceManager().GetConsoleSixAxisSensorTask()
                                     .GetConsoleSixAxisSensorCalibrationValues(&values));

    outValue.Set(values);

    NN_RESULT_SUCCESS;
}

::nn::Result CreateHidTemporaryServerProxy(
    ::nn::sf::SharedPointer<IHidTemporaryServer>* pOutValue) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);
    *pOutValue = StaticObject<
        ::nn::sf::UnmanagedServiceObject<IHidTemporaryServer, HidTemporaryServer>
        >::Get().GetShared();
    NN_RESULT_SUCCESS;
}

}}} // namespace nn::hid::detail
