﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/hid/hid_TouchScreen.h>
#include <nn/hid/debug/hid_AbstractedPad.h>
#include <nn/hid/debug/hid_DebugPad.h>
#include <nn/hid/debug/hid_TouchScreen.h>
#include <nn/hid/debug/hid_Xpad.h>

namespace nn { namespace hid { namespace detail {

//!< HidShell の出力ポートから DebugPad の入力状態を取得します。
::nn::Result GetHidShellDebugPadState(
    bool* pOutFlag,
    ::nn::hid::debug::DebugPadAutoPilotState* pOutState) NN_NOEXCEPT;

//!< HidShell の入力ポートへ DebugPad の入力状態を設定します。
::nn::Result SetHidShellDebugPadState(
    const ::nn::hid::debug::DebugPadAutoPilotState& state) NN_NOEXCEPT;

//!< HidShell の出力ポートから TouchScreen の入力状態を取得します。
::nn::Result GetHidShellTouchScreenState(
    bool* pOutFlag,
    ::nn::hid::debug::TouchScreenAutoPilotState<TouchStateCountMax
        >* pOutState) NN_NOEXCEPT;

//!< HidShell の入力ポートへ TouchScreen の入力状態を設定します。
::nn::Result SetHidShellTouchScreenState(
    const ::nn::hid::debug::TouchScreenAutoPilotState<TouchStateCountMax
        >& state) NN_NOEXCEPT;

//!< HidShell の有効な Xpad の入出力ポートか否かを表す値を返します。
bool IsValidHidShellXpadPort(int port) NN_NOEXCEPT;

//!< HidShell の出力ポートから基本的な構成を持つ Xpad の入力状態を取得します。
::nn::Result GetHidShellXpadState(
    bool* pOutFlag,
    ::nn::hid::debug::BasicXpadAutoPilotState* pOutState,
    int port) NN_NOEXCEPT;

//!< HidShell の入力ポートへ基本的な構成を持つ Xpad の入力状態を設定します。
::nn::Result SetHidShellXpadState(
    int port,
    const ::nn::hid::debug::BasicXpadAutoPilotState& state) NN_NOEXCEPT;

//!< HidShell の有効な AbstractedPad の入出力ポートか否かを表す値を返します。
bool IsValidHidShellAbstractedPadPort(int port) NN_NOEXCEPT;

//!< HidShell の出力ポートから AbstractedPad の入力状態を取得します。
::nn::Result GetHidShellAbstractedPadState(
    bool* pOutFlag,
    ::nn::hid::debug::AbstractedPadState* pOutState,
    int port) NN_NOEXCEPT;

//!< HidShell の入力ポートへ AbstractedPad の入力状態を設定します。
::nn::Result SetHidShellAbstractedPadState(
    int port,
    const ::nn::hid::debug::AbstractedPadState& state) NN_NOEXCEPT;

}}} // namespace nn::hid::detail
