﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/hid/hid_IHidSystemServer.sfdl.h>
#include <nn/hid/hid_NpadJoyCommon.h>
#include <nn/hid/hid_ResultPrivate.h>
#include <nn/hid/system/hid_Result.system.h>
#include <nn/hid/system/hid_UniquePad.h>
#include <nn/os/os_MemoryHeap.h>
#include <nn/os/os_NativeHandle.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/os/os_TransferMemory.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/sf/sf_NativeHandle.h>

#include "hid_HidSystemServer.h"
#include "hid_FirmwareUpdateSystemImpl.h"

namespace nn { namespace hid { namespace system { namespace detail {

::nn::Result InitializeFirmwareUpdate() NN_NOEXCEPT
{
    auto pProxy = ::nn::sf::SharedPointer<IHidSystemServer>();
    ::nn::hid::detail::CreateHidSystemServerProxy(&pProxy);

    NN_RESULT_DO(pProxy->InitializeFirmwareUpdate());
    NN_RESULT_SUCCESS;
}

::nn::Result StartFirmwareUpdate(system::FirmwareUpdateDeviceHandle* pOutHandle,
                                 system::UniquePadId id) NN_NOEXCEPT
{
    auto pProxy = ::nn::sf::SharedPointer<IHidSystemServer>();
    ::nn::hid::detail::CreateHidSystemServerProxy(&pProxy);

    NN_RESULT_DO(pProxy->StartFirmwareUpdate(pOutHandle, id));
    NN_RESULT_SUCCESS;
}

::nn::Result AbortFirmwareUpdate() NN_NOEXCEPT
{
    auto pProxy = ::nn::sf::SharedPointer<IHidSystemServer>();
    ::nn::hid::detail::CreateHidSystemServerProxy(&pProxy);

    NN_RESULT_DO(pProxy->AbortFirmwareUpdate());
    NN_RESULT_SUCCESS;
}

::nn::Result GetFirmwareVersion(system::FirmwareVersion* pOutValue,
                                UniquePadId id) NN_NOEXCEPT
{
    auto pProxy = ::nn::sf::SharedPointer<IHidSystemServer>();
    ::nn::hid::detail::CreateHidSystemServerProxy(&pProxy);

    NN_RESULT_DO(pProxy->GetFirmwareVersion(pOutValue, id));
    NN_RESULT_SUCCESS;
}

::nn::Result GetAvailableFirmwareVersion(system::FirmwareVersion* pOutValue,
                                      UniquePadId id) NN_NOEXCEPT
{
    auto pProxy = ::nn::sf::SharedPointer<IHidSystemServer>();
    ::nn::hid::detail::CreateHidSystemServerProxy(&pProxy);

    NN_RESULT_DO(pProxy->GetAvailableFirmwareVersion(pOutValue, id));
    NN_RESULT_SUCCESS;
}

::nn::Result IsFirmwareUpdateAvailable(bool* pOutIsAvailable,
                                       UniquePadId id) NN_NOEXCEPT
{
    auto pProxy = ::nn::sf::SharedPointer<IHidSystemServer>();
    ::nn::hid::detail::CreateHidSystemServerProxy(&pProxy);

    auto outIsAvailable = bool();
    NN_RESULT_DO(pProxy->IsFirmwareUpdateAvailable(&outIsAvailable, id));
    *pOutIsAvailable = outIsAvailable;

    NN_RESULT_SUCCESS;
}

::nn::Result CheckFirmwareUpdateRequired(FirmwareUpdateRequiredReason* pOutReason,
                                         UniquePadId id) NN_NOEXCEPT
{
    auto pProxy = ::nn::sf::SharedPointer<IHidSystemServer>();
    ::nn::hid::detail::CreateHidSystemServerProxy(&pProxy);

    int64_t outReason = 0;
    NN_RESULT_DO(pProxy->CheckFirmwareUpdateRequired(&outReason, id));
    *pOutReason = static_cast<FirmwareUpdateRequiredReason>(outReason);

    NN_RESULT_SUCCESS;
}

::nn::Result GetFirmwareUpdateState(system::FirmwareUpdateState* pOutState,
                                    const system::FirmwareUpdateDeviceHandle& handle) NN_NOEXCEPT
{
    auto pProxy = ::nn::sf::SharedPointer<IHidSystemServer>();
    ::nn::hid::detail::CreateHidSystemServerProxy(&pProxy);

    NN_RESULT_DO(pProxy->GetFirmwareUpdateState(pOutState, handle));
    NN_RESULT_SUCCESS;
}

::nn::Result SetFirmwareHotfixUpdateSkipEnabled(bool isEnabled) NN_NOEXCEPT
{
    auto pProxy = ::nn::sf::SharedPointer<IHidSystemServer>();
    ::nn::hid::detail::CreateHidSystemServerProxy(&pProxy);

    NN_RESULT_DO(pProxy->SetFirmwareHotfixUpdateSkipEnabled(isEnabled));
    NN_RESULT_SUCCESS;
}

}}}} // namespace nn::hid::system::detail
