﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/hid/hid_ConsoleSixAxisSensor.h>

#include "hid_SixAxisSensorHandle.h"

namespace nn { namespace hid { namespace detail {

//<! ConsoleSixAxisSensorHandle のビットフィールド定義です。
struct ConsoleSixAxisSensorHandleField final
{
    //!< ConsoleSixAxisSensor の種類
    typedef ::nn::util::BitPack32::Field<0, 8, uint8_t> ConsoleSixAxisSensorTypeValue;

    //!< インデックス
    typedef ::nn::util::BitPack32::Field<8, 8, uint8_t> ConsoleSixAxisSensorIndex;
};

enum ConsoleSixAxisSensorTypeValue
{
    // VR 用途の本体 6 軸センサーハンドル
    ConsoleSixAxisSensorTypeValue_Vr = NpadSixAxisSensorTypeValueOffset + 16,
};

//!< ConsoleSixAxisSensorHandle を作成します。
ConsoleSixAxisSensorHandle MakeConsoleSixAxisSensorHandle(uint8_t typeValue, int index) NN_NOEXCEPT;

//!< ConsoleSixAxisSensorHandle から ConsoleSixAxisSensor の種類 (に対応する整数値) を取得します。
uint8_t GetConsoleSixAxisSensorTypeValue(const ConsoleSixAxisSensorHandle& handle) NN_NOEXCEPT;

//!< SixAxisSensorHandle から ConsoleSixAxisSensor のインデックスを取得します。
uint8_t GetConsoleSixAxisSensorIndex(const ConsoleSixAxisSensorHandle& handle) NN_NOEXCEPT;

::nn::Result GetConsoleSixAxisSensorHandle(ConsoleSixAxisSensorHandle* pOutHandle) NN_NOEXCEPT;

}}} // namespace nn::hid::detail
