﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/hid/hid_ConsoleSixAxisSensor.h>
#include <nn/hid/tmp/hid_ConsoleSixAxisSensor.h>

#include "hid_ActivationCount.h"
#include "hid_IConsoleSixAxisSensorDriver.h"

namespace nn { namespace hid { namespace detail {

class ConsoleSixAxisSensorDriver final : public IConsoleSixAxisSensorDriver
{
    NN_DISALLOW_COPY(ConsoleSixAxisSensorDriver);
    NN_DISALLOW_MOVE(ConsoleSixAxisSensorDriver);

private:
    //!< このインスタンスからドライバがアクティブ化された回数
    ActivationCount m_ActivationCount;

    //!< サンプリング番号
    int64_t m_SamplingNumber;

public:
    ConsoleSixAxisSensorDriver() NN_NOEXCEPT;

    virtual ~ConsoleSixAxisSensorDriver() NN_NOEXCEPT NN_OVERRIDE;

    virtual ::nn::Result Activate() NN_NOEXCEPT NN_OVERRIDE;

    virtual ::nn::Result Deactivate() NN_NOEXCEPT NN_OVERRIDE;

    virtual ::nn::Result Wake() NN_NOEXCEPT NN_OVERRIDE;

    virtual ::nn::Result Sleep() NN_NOEXCEPT NN_OVERRIDE;

    virtual ::nn::Result Start(::nn::TimeSpan samplingInterval) NN_NOEXCEPT NN_OVERRIDE;

    virtual ::nn::Result Stop() NN_NOEXCEPT NN_OVERRIDE;

    virtual int GetStates(tmp::SixAxisSensorCountState* pOutValue, int count) NN_NOEXCEPT NN_OVERRIDE;

    virtual ::nn::Result GetConsoleSixAxisSensorCalibrationValues(tmp::ConsoleSixAxisSensorCalibrationValues* pOutValues) NN_NOEXCEPT NN_OVERRIDE;

    virtual void ConvertAcceleration(nn::util::Float3* outValue,
                                     const tmp::SensorCountState& acceleration) const NN_NOEXCEPT NN_OVERRIDE;

    virtual void ConvertAngularVelocity(nn::util::Float3* outValue,
                                        const tmp::SensorCountState& angularVelocity) const NN_NOEXCEPT NN_OVERRIDE;};

}}} // namespace nn::hid::detail
