﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/hid/hid_Xpad.h>
#include <nn/hid/debug/hid_Xpad.h>

namespace nn { namespace hid { namespace detail {

::nn::Result GetXpadIds(int* pOutCount,
                        BasicXpadId outXpadIds[],
                        int count) NN_NOEXCEPT;

::nn::Result GetXpadPlayerNumber(int* pOutValue,
                                 const BasicXpadId& xpadId) NN_NOEXCEPT;

::nn::Result InitializeXpad(const BasicXpadId& xpadId) NN_NOEXCEPT;

::nn::Result FinalizeXpad(const BasicXpadId& xpadId) NN_NOEXCEPT;

::nn::Result GetXpadState(BasicXpadState* pOutValue,
                          const BasicXpadId& xpadId) NN_NOEXCEPT;

::nn::Result GetXpadStates(int* pOutCount,
                           BasicXpadState outStates[],
                           int count,
                           const BasicXpadId& xpadId) NN_NOEXCEPT;

::nn::Result SetXpadAutoPilotState(
    BasicXpadId xpadId,
    const ::nn::hid::debug::BasicXpadAutoPilotState& value) NN_NOEXCEPT;

::nn::Result UnsetXpadAutoPilotState(BasicXpadId xpadId) NN_NOEXCEPT;

::nn::Result AssertValidXpadId(const BasicXpadId& xpadId) NN_NOEXCEPT;

}}} // namespace nn::hid::detail
