﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/os/os_SystemEvent.h>

#include <nn/hid/system/hid_AnalogStickManualCalibration.h>

namespace nn { namespace hid { namespace detail {

::nn::Result StartAnalogStickManualCalibration(system::UniquePadId id, system::AnalogStickPosition position) NN_NOEXCEPT;

::nn::Result RetryCurrentAnalogStickManualCalibrationStage(system::UniquePadId id, system::AnalogStickPosition position) NN_NOEXCEPT;

::nn::Result CancelAnalogStickManualCalibration(system::UniquePadId id, system::AnalogStickPosition position) NN_NOEXCEPT;

::nn::Result ResetAnalogStickManualCalibration(system::UniquePadId id, system::AnalogStickPosition position) NN_NOEXCEPT;

}}} // namespace nn::hid::detail
