﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>

#include "hid_ActivationCount.h"
#include "hid_IAbstractedPad.h"

namespace nn { namespace hid { namespace detail {

//!< AbstractedPad を管理するクラスです。
class AbstractedPadManager final
{
private:
    //!< Activation された回数
    ActivationCount m_ActivationCount;

    //!< 抽象化されたコントローラー
    IAbstractedPad* m_pAbstractedPads[IAbstractedPadCountMax];

    //!< IAbstractedPad の数
    int m_AbstractedPadCount;

public:
    AbstractedPadManager() NN_NOEXCEPT;

    ~AbstractedPadManager() NN_NOEXCEPT;

    //!< 初期化します
    void Initialize() NN_NOEXCEPT;

    //!< IAbstractedPad をセットします
    void AddIAbstractedPad(IAbstractedPad* pPads) NN_NOEXCEPT;

    //!< AbstractedPadManager をアクティブ化します。
    ::nn::Result Activate() NN_NOEXCEPT;

    //!< AbstractedPadManager を非アクティブ化します。
    ::nn::Result Deactivate() NN_NOEXCEPT;

    //!< 有効になっている AbstractedPad の ID を取得します。
    Result GetActiveAbstractedPadIds(int* pOutCount, AbstractedPadId* pOutIds, int count) NN_NOEXCEPT;

    //!< AbstratedPad を取得します。
    Result GetAbstractedPad(IAbstractedPad** pOutPad, AbstractedPadId id) NN_NOEXCEPT;

private:
};

}}} // namespace nn::hid::detail
