﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <type_traits>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/hid/hid_IHidDebugServer.sfdl.h>
#include <nn/hid/hid_ResultPrivate.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/util/util_TypedStorage.h>

#include "hid_AbstractedPadImpl.h"
#include "hid_HidDebugServer.h"

namespace nn { namespace hid { namespace detail {

::nn::Result SetAutoPilotVirtualPadState(const ::nn::hid::debug::AbstractedVirtualPadId& virtualPadId, const ::nn::hid::debug::AbstractedPadState& value) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<IHidDebugServer> pHidDebugServer;
    NN_RESULT_DO(CreateHidDebugServerProxy(&pHidDebugServer));
    NN_RESULT_DO(
        pHidDebugServer->SetAutoPilotVirtualPadState(virtualPadId, value));
    NN_RESULT_SUCCESS;
}

::nn::Result UnsetAutoPilotVirtualPadState(const ::nn::hid::debug::AbstractedVirtualPadId& virtualPadId) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<IHidDebugServer> pHidDebugServer;
    NN_RESULT_DO(CreateHidDebugServerProxy(&pHidDebugServer));
    NN_RESULT_DO(
        pHidDebugServer->UnsetAutoPilotVirtualPadState(virtualPadId));
    NN_RESULT_SUCCESS;
}

::nn::Result UnsetAllAutoPilotVirtualPadState() NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<IHidDebugServer> pHidDebugServer;
    NN_RESULT_DO(CreateHidDebugServerProxy(&pHidDebugServer));
    NN_RESULT_DO(
        pHidDebugServer->UnsetAllAutoPilotVirtualPadState());
    NN_RESULT_SUCCESS;
}

::nn::Result GetAbstractedPadHandles(int* pOutCount, debug::AbstractedPadHandle* pOutHandles, int count) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<IHidDebugServer> pHidDebugServer;
    NN_RESULT_DO(CreateHidDebugServerProxy(&pHidDebugServer));
    NN_RESULT_DO(
        pHidDebugServer->GetAbstractedPadHandles(pOutCount, nn::sf::OutArray<debug::AbstractedPadHandle>(pOutHandles, count)));
    NN_RESULT_SUCCESS;
}

::nn::Result GetAbstractedPadState(debug::AbstractedPadState* pOutState, ::nn::hid::debug::AbstractedPadHandle handle) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<IHidDebugServer> pHidDebugServer;
    NN_RESULT_DO(CreateHidDebugServerProxy(&pHidDebugServer));
    NN_RESULT_DO(
        pHidDebugServer->GetAbstractedPadState(pOutState, handle));
    NN_RESULT_SUCCESS;
}

::nn::Result GetAbstractedPadsState(int* pOutCount, debug::AbstractedPadHandle* pOutHandles, debug::AbstractedPadState* pOutStates, int count) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<IHidDebugServer> pHidDebugServer;
    NN_RESULT_DO(CreateHidDebugServerProxy(&pHidDebugServer));
    NN_RESULT_DO(
        pHidDebugServer->GetAbstractedPadsState(pOutCount,
            nn::sf::OutArray<debug::AbstractedPadHandle>(pOutHandles, count),
            nn::sf::OutArray<debug::AbstractedPadState>(pOutStates, count)));
    NN_RESULT_SUCCESS;
}

}}} // namespace nn::hid::detail
