﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>

#include "hid_GcAdapterDriver.h"
#include "hid_IAbstractedPad.h"

namespace nn { namespace hid { namespace detail {

class AbstractedGcAdapterPad final : public IAbstractedPad
{
private:
    static const AbstractedPadType s_Type = AbstractedPadType_GcAdapter;

    //!< コントローラーの接続状態
    bool m_IsConnected;

    //!< Gc コントローラー の index
    GcControllerIndex m_Index;

    //!< コントローラーの入力状態
    AbstractedPadState m_PadState;

    //!< L トリガーの状態
    int32_t m_TriggerL;

    //!< R トリガーの状態
    int32_t m_TriggerR;

    //!< インジケーターパターン
    uint8_t m_Pattern;

    //!< 入力無効化するボタン状態
    GcControllerButtonSet m_ButtonMask;

    //!< 古いボタンの状態
    GcControllerButtonSet m_OldButtons;

    //!< Gc コントローラーアダプタードライバー
    GcAdapterDriver* m_pDriver;

public:
    AbstractedGcAdapterPad() NN_NOEXCEPT;
    virtual ~AbstractedGcAdapterPad() NN_NOEXCEPT NN_OVERRIDE;

    //!< AbstractedPadType を取得する
    virtual AbstractedPadType GetType() NN_NOEXCEPT NN_OVERRIDE;

    //!< デバイスの接続状態を取得する
    virtual bool IsConnected() NN_NOEXCEPT NN_OVERRIDE;

    //!< デバイスの電源状態を取得する
    virtual system::PowerInfo GetPowerInfo() NN_NOEXCEPT NN_OVERRIDE;

    //!< デバイスのボタン/アナログスティックの入力状態を取得する
    virtual AbstractedPadState GetPadState() NN_NOEXCEPT NN_OVERRIDE;

    //!< 最後にボタンが押下された時間を取得する
    virtual bool GetButtonTriggerElapsedTime(nn::os::Tick* pOutTick, AbstractedPadButtonSet button) NN_NOEXCEPT NN_OVERRIDE;

    //!< 6軸センサーの値を取得する。暫定的に xcd の構造体を利用する
    virtual int GetSensorStates(nn::xcd::SixAxisSensorState* pOutValue, int count) NN_NOEXCEPT NN_OVERRIDE;

    //!< コントローラーのインジケーターを制御する
    virtual void SetIndicator(uint8_t pattern, bool blink) NN_NOEXCEPT NN_OVERRIDE;

    //!< コントローラーのインジケーターパターンを取得する
    virtual uint8_t GetIndicator() NN_NOEXCEPT NN_OVERRIDE;

    //!< ケーブル接続されているかどうか
    virtual bool IsWired() NN_NOEXCEPT NN_OVERRIDE;

    //!< Usb の接続状態を取得します
    virtual bool IsUsbConnected() NN_NOEXCEPT NN_OVERRIDE;

    //!< コントローラーを接続状態に変更します
    virtual void Connect() NN_NOEXCEPT NN_OVERRIDE;

    //!< コントローラーを切断する
    virtual void Detach() NN_NOEXCEPT NN_OVERRIDE;

    //!< 接続時の振動を行う
    virtual void VibrationOnConnect() NN_NOEXCEPT NN_OVERRIDE;

    //!< バッテリーを搭載しているかどうか取得します
    virtual bool HasBattery() NN_NOEXCEPT NN_OVERRIDE;

    //!< プレイレポート用のデフォルトの情報を取得します
    virtual bool SetDeviceInfoOnPlayReportControllerUsage(system::PlayReportControllerUsage* pOutValue) NN_NOEXCEPT NN_OVERRIDE;

    //!< ドライバーを設定する
    void SetGcAdapterDriver(GcAdapterDriver* pDriver) NN_NOEXCEPT;

    //!< デバイスを追加する
    void AttachDevice(const GcControllerIndex& index, AbstractedPadId id) NN_NOEXCEPT;

    //!< デバイスを削除する
    void RemoveDevice() NN_NOEXCEPT;

    //!< Gc コントローラーのインデックスを取得します
    GcControllerIndex GetIndex() NN_NOEXCEPT;

    //!< 内部状態を更新する
    void Update() NN_NOEXCEPT;

    //!< L/R トリガーの状態を取得します
    void GetTrigger(int32_t* pOutTriggerL, int32_t* pOutTriggerR) NN_NOEXCEPT;

private:
    //!< デバイスの入力状態を更新する
    void UpdatePadState() NN_NOEXCEPT;
};

}}} // namespace nn::hid::detail
