﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/hid/hid_NpadCommonTypes.h>
#include <nn/hid/debug/hid_Xpad.h>

#include "hid_AbstractedPadIdPublisher.h"
#include "hid_IAbstractedPad.h"

namespace nn { namespace hid { namespace detail {

class AbstractedAutoPilotPad final : public IAbstractedPad
{
private:
    static const AbstractedPadType s_Type = AbstractedPadType_Usb;

    //!< AbstractedId パブリッシャー
    AbstractedPadIdPublisher* m_pIdPublisher;

    //!< コントローラーの接続状態
    bool m_IsConnected;

    //!< NpadId への強制割り当てが有効化どうか
    bool m_FixedNpadAssignmentEnabled;

    //!< NpadId への強制割り当てで割り当てる NpadIdType
    NpadIdType m_NpadId;

    //!< コントローラーの入力状態
    AbstractedPadState m_PadState;

    //!< インジケーターパターン
    uint8_t m_Pattern;

public:
    AbstractedAutoPilotPad() NN_NOEXCEPT;
    virtual ~AbstractedAutoPilotPad() NN_NOEXCEPT NN_OVERRIDE;

    //!< AbstractedPadType を取得する
    virtual AbstractedPadType GetType() NN_NOEXCEPT NN_OVERRIDE;

    //!< デバイスの接続状態を取得する
    virtual bool IsConnected() NN_NOEXCEPT NN_OVERRIDE;

    //!< デバイスの電源状態を取得する
    virtual system::PowerInfo GetPowerInfo() NN_NOEXCEPT NN_OVERRIDE;

    //!< デバイスのボタン/アナログスティックの入力状態を取得する
    virtual AbstractedPadState GetPadState() NN_NOEXCEPT NN_OVERRIDE;

    //!< 最後にボタンが押下された時間を取得する
    virtual bool GetButtonTriggerElapsedTime(nn::os::Tick* pOutTick, AbstractedPadButtonSet button) NN_NOEXCEPT NN_OVERRIDE;

    //!< 6軸センサーの値を取得する。暫定的に xcd の構造体を利用する
    virtual int GetSensorStates(nn::xcd::SixAxisSensorState* pOutValue, int count) NN_NOEXCEPT NN_OVERRIDE;

    //!< コントローラーのインジケーターを制御する
    virtual void SetIndicator(uint8_t pattern, bool blink) NN_NOEXCEPT NN_OVERRIDE;

    //!< コントローラーのインジケーターパターンを取得する
    virtual uint8_t GetIndicator() NN_NOEXCEPT NN_OVERRIDE;

    //!< ケーブル接続されているかどうか
    virtual bool IsWired() NN_NOEXCEPT NN_OVERRIDE;

    //!< Usb の接続状態を取得します
    virtual bool IsUsbConnected() NN_NOEXCEPT NN_OVERRIDE;

    //!< コントローラーを接続状態に変更します
    virtual void Connect() NN_NOEXCEPT NN_OVERRIDE;

    //!< コントローラーを切断する
    virtual void Detach() NN_NOEXCEPT NN_OVERRIDE;

    //!< NpadId への指定割り当てが有効かどうかをチェックします
    virtual bool IsFixedNpadAssignmentEnabled(NpadIdType* pOutValue) NN_NOEXCEPT NN_OVERRIDE;

    //!< バッテリーを搭載しているかどうか取得します
    virtual bool HasBattery() NN_NOEXCEPT NN_OVERRIDE;

    //!< プレイレポート用のデフォルトの情報を取得します
    virtual bool SetDeviceInfoOnPlayReportControllerUsage(system::PlayReportControllerUsage* pOutValue) NN_NOEXCEPT NN_OVERRIDE;

    //!< AbstractedId パブリッシャーをセットします
    void SetAbstractedPadIdPublisher(AbstractedPadIdPublisher* pPublisher) NN_NOEXCEPT;

    //!< NpadId をセットする
    void SetNpadIdType(const NpadIdType& id) NN_NOEXCEPT;

    //!< Npad に自動操作状態を設定します。
    ::nn::Result SetAutoPilotState(
        const ::nn::hid::debug::BasicXpadAutoPilotState& value) NN_NOEXCEPT;

    //!< Npad の自動操作状態を解除します。
    ::nn::Result UnsetAutoPilotState() NN_NOEXCEPT;
};

}}} // namespace nn::hid::detail
