﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <binder/Parcel.h>

namespace nn{ namespace grcsrv{ namespace offscreen{ namespace native{

    class ParcelIo
    {
    public:
        // @brief pSrcData の内容を使って Parcel を作成します。CloseParcel() で破棄します。
        // @details
        // 失敗した場合 returnValue != NO_ERROR
        static android::status_t OpenParcel(android::Parcel* pOutParcel, size_t* pOutDataPosition, const void* pSrcData, size_t srcDataSize) NN_NOEXCEPT;
        // @brief Parcel を破棄します。
        static void CloseParcel(android::Parcel* pParcel) NN_NOEXCEPT;

        // @brief Parcel の内容を pBuffer に書き出します。
        // @details
        // 失敗した場合 *pOutSize == 0.
        static void WriteParcel(size_t* pOutSize, void* pBuffer, size_t bufferSize, const android::Parcel* pParcel) NN_NOEXCEPT;

        // @brief Parcel 中の Binder の内部ハンドルのリストを取得します。
        static nn::Result ExtractBinderHandleList(int* pOutCount, int32_t* buf, int length, android::Parcel* pParcel) NN_NOEXCEPT;

        // @brief Parcel 中の Binder のサービス名をすべて書き換えます。
        static void ReplaceBinderServiceName(android::Parcel* pParcel, const char* name) NN_NOEXCEPT;

        static void ReplaceBinderServiceName(void* buffer, size_t size, const char* name) NN_NOEXCEPT;

    };

}}}}
