﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/vi/native/vi_NativeType.h>
#include <utils/String8.h>
#include <ui/PixelFormat.h>

// nvcommon.h
typedef unsigned char      NvU8;
typedef unsigned short     NvU16;
typedef unsigned int       NvU32;
typedef unsigned long long NvU64;
typedef signed char        NvS8;
typedef signed short       NvS16;
typedef signed int         NvS32;
typedef signed long long   NvS64;
typedef float              NvF32;
typedef double             NvF64;

// NvRm
typedef struct NvRmDeviceRec *NvRmDeviceHandle;

typedef struct NvRmFenceRec NvRmFence;

typedef struct NvOsEventRec NvOsEvent;

#ifdef __LP64__
typedef NvU32 NvRmMemHandle;
#else
typedef struct NvRmMemRec *NvRmMemHandle;
#endif

typedef struct NvRmSurfaceRec NvRmSurface;

// sync
struct syncfd_nvrm_mapping;

// native_handle.h
typedef struct native_handle native_handle_t;

// window.h
typedef const native_handle_t* buffer_handle_t;

// gralloc.h
typedef struct alloc_device_t alloc_device_t;



namespace android{

    // 3rdparty/android-hos/system/core/include/utils/StrongPointer.h
    template<typename T>class sp;

    class Fence;
    class GraphicBuffer;
    class Parcel;
    class String16;

}

namespace nn{ namespace grcsrv{ namespace offscreen{ namespace native{

    static const int NativeRmSyncFenceCountMax = 4;

    // compatible type for NvRmFence
    struct NativeRmFence
    {
    public:
        NativeRmFence() NN_NOEXCEPT;
        explicit NativeRmFence(const NvRmFence& src) NN_NOEXCEPT;

    public:
        uint32_t syncpointId;
        uint32_t value;
    };

    struct NativeRmSync
    {
    public:
        static const int FenceCountMax = NativeRmSyncFenceCountMax;

    public:
        NativeRmSync() NN_NOEXCEPT;

        void Clear() NN_NOEXCEPT;
        void WriteTo(nn::vi::native::NativeSync* pOutValue) const NN_NOEXCEPT;
        // 成功した場合 true
        // fd が MAX_FD_MAPPINGS (=140, see sync_nvrm.c) 個までしか作れない
        bool WriteTo(android::sp<android::Fence>* pOutValue) const NN_NOEXCEPT;
        void ReadFrom(const nn::vi::native::NativeSync& value) NN_NOEXCEPT;
        void ReadFrom(const syncfd_nvrm_mapping& value) NN_NOEXCEPT;
        void ReadFrom(const android::sp<android::Fence>& value) NN_NOEXCEPT;

    public:
        uint32_t count;
        NativeRmFence fenceList[FenceCountMax];
    };

}}}}
