﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os.h>

#include "../grcsrv_NativeType.h"

namespace nn{ namespace grcsrv{ namespace offscreen{ namespace native{
    class SyncpointEntry;
}}}}

namespace nn{ namespace grcsrv{ namespace offscreen{ namespace native{ namespace detail{

    class SyncpointEventManager
    {
    public:
        static const int Size = 16;
        static const int EventSlotOffset = 64 - Size;
    public:
        enum SlotState
        {
            SlotState_Empty,
            SlotState_Unused,
            SlotState_Waiting,
        };

        struct Slot
        {
            SlotState           state;
            NvOsEvent*          pEvent;
            SyncpointEntry* pEntry;
        };

    public:
        SyncpointEventManager() NN_NOEXCEPT;

        void Initialize() NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        bool IsFull() const NN_NOEXCEPT;
        bool IsEmpty() const NN_NOEXCEPT;
        // 既に expired なら true
        bool AcquireWaitSlot(int* pOutSlotIndex, const NativeRmFence& fence, SyncpointEntry* pEntry) NN_NOEXCEPT;
        void ReleaseWaitSlot(int slotIndex) NN_NOEXCEPT;
        void CancelWaitSlot(int slotIndex) NN_NOEXCEPT;

        SyncpointEntry* GetEntry(int slotIndex) NN_NOEXCEPT;
        nn::os::MultiWaitHolderType* GetMultiWaitHolder(int slotIndex) NN_NOEXCEPT;

    private:
        void CreateSlotImpl(int slotIndex) NN_NOEXCEPT;
        void DestroySlotImpl(int slotIndex) NN_NOEXCEPT;

    private:
        int m_DeviceFd;
        Slot m_SlotList[Size];
    };

}}}}}
