﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "grcsrvOffscreen_LibraryState.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/grc/grc_Result.h>

#include "grcsrvOffscreen_Config.h"
#include "grcsrvOffscreen_Macro.h"

namespace nn{ namespace grcsrv{ namespace offscreen{

    nn::Result LibraryState::InitializeCaptureModule() NN_NOEXCEPT
    {
        nn::capsrv::capture::InitializeCaptureModule();
        m_pCaptureModule = nn::capsrv::capture::GetCaptureModule();
        NN_RESULT_SUCCESS;
    }

    void LibraryState::FinalizeCaptureModule() NN_NOEXCEPT
    {
        nn::capsrv::capture::FinalizeCaptureModule();
        m_pCaptureModule = nullptr;
    }

    nn::Result LibraryState::InitializeMovieFileSystem(void* memory, size_t size) NN_NOEXCEPT
    {
        auto& obj = m_MovieFileSystem;
        obj.m_FileSystem.Initialize("movie");
        obj.m_pMemory = memory;
        obj.m_MemorySize = size;
        obj.m_AttachedStreamHandle = nn::util::nullopt;
        NN_RESULT_SUCCESS;
    }

    void LibraryState::FinalizeMovieFileSystem() NN_NOEXCEPT
    {
        auto& obj = m_MovieFileSystem;
        obj.m_FileSystem.Finalize();
        obj.m_pMemory = nullptr;
        obj.m_MemorySize = 0;
        obj.m_AttachedStreamHandle = nn::util::nullopt;
    }

    nn::Result LibraryState::AttachMovieFileData(nn::fs::FileHandle* pOutFileHandle, nn::capsrv::AlbumMovieWriteStreamHandle hStream) NN_NOEXCEPT
    {
        auto& obj = m_MovieFileSystem;
        NN_RESULT_DO(obj.m_FileSystem.AttachMovieWriteStreamDataSection(
            pOutFileHandle,
            hStream,
            256 * 1024,
            1,
            obj.m_pMemory,
            obj.m_MemorySize
        ));
        obj.m_AttachedStreamHandle = hStream;
        NN_RESULT_SUCCESS;
    }

    void LibraryState::DetachMovieFileData(nn::fs::FileHandle hFile) NN_NOEXCEPT
    {
        auto& obj = m_MovieFileSystem;
        obj.m_FileSystem.DetachMovieWriteStreamDataSection(hFile);
        obj.m_AttachedStreamHandle = nn::util::nullopt;
    }

    nn::Result LibraryState::InitializeMovieMeta(void* memory, size_t size) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_GREATER_EQUAL(size, nn::capsrv::movie::MovieMetaDataSize);
        auto& obj = m_MovieMeta;
        obj.m_pMemory = memory;
        obj.m_MemorySize = size;
        NN_RESULT_SUCCESS;
    }

    void LibraryState::FinalizeMovieMeta() NN_NOEXCEPT
    {
        auto& obj = m_MovieMeta;
        obj.m_pMemory = nullptr;
        obj.m_MemorySize = 0;
    }

}}}
