﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os.h>
#include "../grcsrvOffscreen_Macro.h"
NN_PRAGMA_PUSH_WARNINGS
NN_GRCSRV_SUPPRESS_MOVIE_WARNINGS
#include <media/stagefright/MediaCodec.h>
#include <nvnflinger_service.h>
NN_PRAGMA_POP_WARNINGS
#include <nn/grc/grc_CommonTypes.h>

namespace nn{ namespace grcsrv{ namespace offscreen{ namespace detail{

    struct AudioEncoderInput
    {
        int32_t status;
        size_t index;
        android::sp<android::ABuffer> buffer;
    };

    struct AudioEncoderOutput
    {
        int32_t status;
        size_t index;
        size_t offset;
        size_t size;
        int64_t timestamp;
        uint32_t flags;
        android::sp<android::ABuffer> buffer;
    };

    class AudioEncoderHandler
    {
    public:
        enum class State
        {
            NotInitialized,
            Stop,
            Running,
        };

    public:
        AudioEncoderHandler() NN_NOEXCEPT;

        bool IsInitialized() const NN_NOEXCEPT;

        nn::Result Initialize() NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        nn::Result Start(const nn::grc::OffscreenRecordingParameter& param) NN_NOEXCEPT;
        void Stop() NN_NOEXCEPT;

        nn::Result AcquireInputBuffer(AudioEncoderInput* pOutValue) NN_NOEXCEPT;
        nn::Result TryAcquireInputBuffer(AudioEncoderInput* pOutValue) NN_NOEXCEPT;
        nn::Result QueueInputBuffer(int32_t* pOutStatus, size_t index, size_t offset, size_t size, int64_t timestampUs, uint32_t flags) NN_NOEXCEPT;

        nn::Result AcquireOutputBuffer(AudioEncoderOutput* pOutValue) NN_NOEXCEPT;
        nn::Result ReleaseOutputBuffer(int32_t* pOutStatus, size_t index) NN_NOEXCEPT;

        nn::Result GetOutputFormat(int32_t* pOutStatus, android::sp<android::AMessage>* pOutValue) NN_NOEXCEPT;
    private:
        State m_State;
        nn::os::MutexType m_Mutex;

        int32_t m_BitRate;
        int32_t m_SampleRate;
        int32_t m_ChannelCount;
        int32_t m_SampleFormat;

        android::sp<android::ALooper>    m_pLooper;
        android::sp<android::AMessage>   m_pFormat;
        android::sp<android::MediaCodec> m_pEncoder;
        android::Vector<android::sp<android::ABuffer>> m_EncoderInputBufferList;
        android::Vector<android::sp<android::ABuffer>> m_EncoderOutputBufferList;
    };

}}}}
