﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/grcsrv/grcsrv_GrcServices.sfdl.h>

namespace nn{ namespace grcsrv{

    class OffscreenRecorderImpl
    {
    public:
        OffscreenRecorderImpl() NN_NOEXCEPT;
        Result Initialize(sf::NativeHandle&& workMemoryHandle, uint64_t workMemorySize) NN_NOEXCEPT;
        ~OffscreenRecorderImpl() NN_NOEXCEPT;

        nn::Result CreateOffscreenLayer(nn::sf::Out<std::uint64_t> outHandle, nn::applet::AppletResourceUserId rendererAruid) NN_NOEXCEPT;
        nn::Result DestroyOffscreenLayer(std::uint64_t handle) NN_NOEXCEPT;

    private:
        void DestroyOffsreenLayerImpl(std::uint64_t handle);

    private:
        uint64_t m_CreatedLayerHandle;
        bool m_IsUnbindingTransferMemoryRequired;
    };

    void RegisterOffscreenLayerDestroyingCallback(int* pOutSlot, void (*func)(uint64_t layerHandle, void* userPtr), void* userPtr) NN_NOEXCEPT;
    void UnregisterOffscreenLayerDestroyingCallback(int slot) NN_NOEXCEPT;

}}
